/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.maven.yuicompressor;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import net_alchim31_maven_yuicompressor.Aggregation;
import net_alchim31_maven_yuicompressor.MojoSupport;
import net_alchim31_maven_yuicompressor.SourceFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;
import org.zkoss.maven.yuicompressor.CssCompressor;
import org.zkoss.maven.yuicompressor.util.Comments;
import org.zkoss.maven.yuicompressor.util.UnicodeReader;

public class YuiCompressorMojo
extends MojoSupport {
    private String encoding;
    private String suffix;
    private String sourcesuffix;
    private boolean nosource;
    private boolean nosuffix;
    private int linebreakpos;
    private boolean nomunge;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private boolean force;
    private boolean removeSourceComment;
    private Aggregation[] aggregations;
    private boolean gzip;
    private boolean statistics;
    private long inSizeTotal_;
    private long outSizeTotal_;

    protected String[] getDefaultIncludes() throws Exception {
        return new String[]{"**/*.css.dsp", "**/*.css", "**/*.js"};
    }

    public void beforeProcess() throws Exception {
        if (this.nosuffix) {
            this.suffix = "";
        }
    }

    protected void afterProcess() throws Exception {
        if (this.statistics && this.inSizeTotal_ > 0L) {
            this.getLog().info((CharSequence)String.format("total input (%db) -> output (%db)[%d%%]", this.inSizeTotal_, this.outSizeTotal_, this.outSizeTotal_ * 100L / this.inSizeTotal_));
        }
        if (this.aggregations != null) {
            for (Aggregation aggregation : this.aggregations) {
                this.getLog().info((CharSequence)("generate aggregation : " + aggregation.output));
                aggregation.run();
                File gzipped = this.gzipIfRequested(aggregation.output);
                if (!this.statistics) continue;
                if (gzipped != null) {
                    this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", aggregation.output.getName(), aggregation.output.length(), gzipped.getName(), gzipped.length(), this.ratioOfSize(aggregation.output, gzipped)));
                    continue;
                }
                if (aggregation.output.exists()) {
                    this.getLog().info((CharSequence)String.format("%s (%db)", aggregation.output.getName(), aggregation.output.length()));
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("%s not created", aggregation.output.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(SourceFile src) throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("compress file :" + src.toFile() + " to " + src.toDestFile(this.suffix)));
        }
        File inFile = src.toFile();
        File outFile = src.toDestFile(this.suffix);
        File copyToFile = null;
        this.getLog().debug((CharSequence)"only compress if input file is younger than existing output file");
        if (!this.force && outFile.exists() && outFile.lastModified() > inFile.lastModified()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("nothing to do, " + outFile + " is younger than original, use 'force' option or clean your target"));
            }
            return;
        }
        if (!"".equals(this.sourcesuffix) && !this.nosource) {
            this.getLog().info((CharSequence)("compress source :[" + this.sourcesuffix + "]"));
            if (!".css".equalsIgnoreCase(src.getExtension()) && !src.toFile().getName().endsWith(".css.dsp")) {
                copyToFile = src.toDestFile(this.sourcesuffix);
                if (copyToFile.exists() && copyToFile.lastModified() > inFile.lastModified()) {
                    if (this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)("nothing to do, " + copyToFile + " is younger than original, clean your target instead."));
                    }
                    return;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("copyFile inFile from: " + inFile.getAbsolutePath() + " to: " + copyToFile.getAbsolutePath()));
                }
                if (this.removeSourceComment) {
                    this.getLog().info((CharSequence)("remove js comment: " + copyToFile.getName()));
                    String fileContent = FileUtils.fileRead((File)inFile, (String)this.encoding);
                    try {
                        fileContent = Comments.removeComment(fileContent);
                    }
                    catch (IllegalStateException ex) {
                        this.getLog().error((CharSequence)("clear comment failed:" + copyToFile.getName() + ":" + ex.getMessage() + ":skip clear comment step"));
                    }
                    FileUtils.fileWrite((String)copyToFile.getAbsolutePath(), (String)this.encoding, (String)fileContent);
                } else {
                    FileUtils.copyFile((File)inFile, (File)copyToFile);
                }
            }
        }
        UnicodeReader in = null;
        OutputStreamWriter out = null;
        File outFileTmp = new File(outFile.getAbsolutePath() + ".tmp");
        FileUtils.forceDelete((File)outFileTmp);
        try {
            Object compressor;
            in = new UnicodeReader((InputStream)new FileInputStream(inFile), this.encoding);
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new MojoExecutionException("Cannot create resource output directory: " + outFile.getParentFile());
            }
            this.getLog().debug((CharSequence)"use a temporary outputfile (in case in == out)");
            this.getLog().debug((CharSequence)"start compression");
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTmp), this.encoding);
            if (".js".equalsIgnoreCase(src.getExtension())) {
                compressor = new JavaScriptCompressor((Reader)in, (ErrorReporter)this.jsErrorReporter_);
                compressor.compress((Writer)out, this.linebreakpos, !this.nomunge, this.jswarn, this.preserveAllSemiColons, this.disableOptimizations);
            } else if (".css".equalsIgnoreCase(src.getExtension()) || src.toFile().getName().endsWith(".css.dsp")) {
                compressor = new CssCompressor(in);
                ((CssCompressor)compressor).compress(out, this.linebreakpos);
            }
            this.getLog().debug((CharSequence)"end compression");
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
        FileUtils.forceDelete((File)outFile);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("rename outFile from: " + outFileTmp.getAbsolutePath() + " to: " + outFile.getAbsolutePath()));
        }
        FileUtils.rename((File)outFileTmp, (File)outFile);
        if (copyToFile != null) {
            copyToFile.setLastModified(outFile.lastModified() + 500L);
        }
        File gzipped = this.gzipIfRequested(outFile);
        if (this.statistics) {
            this.inSizeTotal_ += inFile.length();
            this.outSizeTotal_ += outFile.length();
            this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", inFile.getName(), inFile.length(), outFile.getName(), outFile.length(), this.ratioOfSize(inFile, outFile)));
            if (gzipped != null) {
                this.getLog().info((CharSequence)String.format("%s (%db) -> %s (%db)[%d%%]", inFile.getName(), inFile.length(), gzipped.getName(), gzipped.length(), this.ratioOfSize(inFile, gzipped)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File gzipIfRequested(File file) throws Exception {
        if (!this.gzip || file == null || !file.exists()) {
            return null;
        }
        if (".gz".equalsIgnoreCase(FileUtils.getExtension((String)file.getName()))) {
            return null;
        }
        File gzipped = new File(file.getAbsolutePath() + ".gz");
        this.getLog().debug((CharSequence)String.format("create gzip version : %s", gzipped.getName()));
        GZIPOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(gzipped));
            in = new FileInputStream(file);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return gzipped;
    }

    protected long ratioOfSize(File file100, File fileX) throws Exception {
        long v100 = Math.max(file100.length(), 1L);
        long vX = Math.max(fileX.length(), 1L);
        return vX * 100L / v100;
    }
}

