/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pqc.jcajce.provider.rainbow;

import java.security.PublicKey;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.DERNull;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.kg.bouncycastle.pqc.asn1.RainbowPublicKey;
import org.kg.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.kg.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.kg.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import org.kg.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import org.kg.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import org.kg.bouncycastle.util.Arrays;

public class BCRainbowPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;
    private RainbowParameters rainbowParams;

    public BCRainbowPublicKey(int docLength, short[][] coeffQuadratic, short[][] coeffSingular, short[] coeffScalar) {
        this.docLength = docLength;
        this.coeffquadratic = coeffQuadratic;
        this.coeffsingular = coeffSingular;
        this.coeffscalar = coeffScalar;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec keySpec) {
        this(keySpec.getDocLength(), keySpec.getCoeffQuadratic(), keySpec.getCoeffSingular(), keySpec.getCoeffScalar());
    }

    public BCRainbowPublicKey(RainbowPublicKeyParameters params) {
        this(params.getDocLength(), params.getCoeffQuadratic(), params.getCoeffSingular(), params.getCoeffScalar());
    }

    public int getDocLength() {
        return this.docLength;
    }

    public short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public short[][] getCoeffSingular() {
        short[][] copy = new short[this.coeffsingular.length][];
        int i = 0;
        while (i != this.coeffsingular.length) {
            copy[i] = Arrays.clone(this.coeffsingular[i]);
            ++i;
        }
        return copy;
    }

    public short[] getCoeffScalar() {
        return Arrays.clone(this.coeffscalar);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCRainbowPublicKey)) {
            return false;
        }
        BCRainbowPublicKey otherKey = (BCRainbowPublicKey)other;
        return this.docLength == otherKey.getDocLength() && RainbowUtil.equals(this.coeffquadratic, otherKey.getCoeffQuadratic()) && RainbowUtil.equals(this.coeffsingular, otherKey.getCoeffSingular()) && RainbowUtil.equals(this.coeffscalar, otherKey.getCoeffScalar());
    }

    public int hashCode() {
        int hash = this.docLength;
        hash = hash * 37 + Arrays.hashCode(this.coeffquadratic);
        hash = hash * 37 + Arrays.hashCode(this.coeffsingular);
        hash = hash * 37 + Arrays.hashCode(this.coeffscalar);
        return hash;
    }

    public final String getAlgorithm() {
        return "Rainbow";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        RainbowPublicKey key = new RainbowPublicKey(this.docLength, this.coeffquadratic, this.coeffsingular, this.coeffscalar);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, (ASN1Encodable)DERNull.INSTANCE);
        return KeyUtil.getEncodedSubjectPublicKeyInfo(algorithmIdentifier, key);
    }
}

