/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pqc.jcajce.provider.gmss;

import java.security.PublicKey;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.pqc.asn1.GMSSPublicKey;
import org.kg.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.kg.bouncycastle.pqc.asn1.ParSet;
import org.kg.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.kg.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import org.kg.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import org.kg.bouncycastle.pqc.jcajce.spec.GMSSPublicKeySpec;
import org.kg.bouncycastle.util.encoders.Hex;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] pub, GMSSParameters gmssParameterSet) {
        this.gmssParameterSet = gmssParameterSet;
        this.publicKeyBytes = pub;
    }

    protected BCGMSSPublicKey(GMSSPublicKeySpec keySpec) {
        this(keySpec.getPublicKey(), keySpec.getParameters());
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters params) {
        this(params.getPublicKey(), params.getParameters());
    }

    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String out = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes)) + "\n" + "Height of Trees: \n";
        int i = 0;
        while (i < this.gmssParameterSet.getHeightOfTrees().length) {
            out = String.valueOf(out) + "Layer " + i + " : " + this.gmssParameterSet.getHeightOfTrees()[i] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i] + " K: " + this.gmssParameterSet.getK()[i] + "\n";
            ++i;
        }
        return out;
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, (ASN1Encodable)new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    public String getFormat() {
        return "X.509";
    }
}

