/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.kg.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.kg.bouncycastle.cert.CertIOException;
import org.kg.bouncycastle.operator.InputDecryptor;
import org.kg.bouncycastle.operator.InputDecryptorProvider;
import org.kg.bouncycastle.pkcs.PKCSException;
import org.kg.bouncycastle.util.io.Streams;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;

    private static EncryptedPrivateKeyInfo parseBytes(byte[] pkcs8Encoding) throws IOException {
        try {
            return EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(pkcs8Encoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo(byte[] encryptedPrivateKeyInfo) throws IOException {
        this(PKCS8EncryptedPrivateKeyInfo.parseBytes(encryptedPrivateKeyInfo));
    }

    public EncryptedPrivateKeyInfo toASN1Structure() {
        return this.encryptedPrivateKeyInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.encryptedPrivateKeyInfo.getEncoded();
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        try {
            InputDecryptor decrytor = inputDecryptorProvider.get(this.encryptedPrivateKeyInfo.getEncryptionAlgorithm());
            ByteArrayInputStream encIn = new ByteArrayInputStream(this.encryptedPrivateKeyInfo.getEncryptedData());
            return PrivateKeyInfo.getInstance(Streams.readAll(decrytor.getInputStream(encIn)));
        }
        catch (Exception e) {
            throw new PKCSException("unable to read encrypted data: " + e.getMessage(), e);
        }
    }
}

