/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.DERNull;
import org.kg.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.kg.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.kg.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.kg.bouncycastle.jcajce.NamedJcaJceHelper;
import org.kg.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.OperatorException;
import org.kg.bouncycastle.operator.SymmetricKeyWrapper;
import org.kg.bouncycastle.operator.jcajce.OperatorHelper;
import org.kg.bouncycastle.operator.jcajce.OperatorUtils;

public class JceSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private SecretKey wrappingKey;

    public JceSymmetricKeyWrapper(SecretKey wrappingKey) {
        super(JceSymmetricKeyWrapper.determineKeyEncAlg(wrappingKey));
        this.wrappingKey = wrappingKey;
    }

    public JceSymmetricKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyWrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceSymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Key contentEncryptionKeySpec = OperatorUtils.getJceKey(encryptionKey);
        Cipher keyEncryptionCipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        try {
            keyEncryptionCipher.init(3, (Key)this.wrappingKey, this.random);
            return keyEncryptionCipher.wrap(contentEncryptionKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new OperatorException("cannot wrap key: " + e.getMessage(), e);
        }
    }

    private static AlgorithmIdentifier determineKeyEncAlg(SecretKey key) {
        String algorithm = key.getAlgorithm();
        if (algorithm.startsWith("DES")) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if (algorithm.startsWith("RC2")) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (ASN1Encodable)new ASN1Integer(58L));
        }
        if (algorithm.startsWith("AES")) {
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (length == 192) {
                wrapOid = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (length == 256) {
                wrapOid = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier(wrapOid);
        }
        if (algorithm.startsWith("SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (algorithm.startsWith("Camellia")) {
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (length == 192) {
                wrapOid = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (length == 256) {
                wrapOid = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier(wrapOid);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

