/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.kg.bouncycastle.jcajce.NamedJcaJceHelper;
import org.kg.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.kg.bouncycastle.operator.DigestCalculator;
import org.kg.bouncycastle.operator.DigestCalculatorProvider;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.operator.jcajce.OperatorHelper;

public class JcaDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcaDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaDigestCalculatorProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public DigestCalculatorProvider build() throws OperatorCreationException {
        return new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                DigestOutputStream stream;
                try {
                    MessageDigest dig = JcaDigestCalculatorProviderBuilder.this.helper.createDigest(algorithm);
                    stream = new DigestOutputStream(dig);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
                return new DigestCalculator(this, algorithm, stream){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ AlgorithmIdentifier val$algorithm;
                    private final /* synthetic */ DigestOutputStream val$stream;
                    {
                        this.this$1 = var1_1;
                        this.val$algorithm = algorithmIdentifier;
                        this.val$stream = digestOutputStream;
                    }

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return this.val$algorithm;
                    }

                    public OutputStream getOutputStream() {
                        return this.val$stream;
                    }

                    public byte[] getDigest() {
                        return this.val$stream.getDigest();
                    }
                };
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

