/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.kg.bouncycastle.crypto.CryptoException;
import org.kg.bouncycastle.crypto.Signer;

public class BcSignerOutputStream
extends OutputStream {
    private Signer sig;

    BcSignerOutputStream(Signer sig) {
        this.sig = sig;
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.sig.update(bytes, off, len);
    }

    public void write(byte[] bytes) throws IOException {
        this.sig.update(bytes, 0, bytes.length);
    }

    public void write(int b) throws IOException {
        this.sig.update((byte)b);
    }

    byte[] getSignature() throws CryptoException {
        return this.sig.generateSignature();
    }

    boolean verify(byte[] expected) {
        return this.sig.verifySignature(expected);
    }
}

