/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.kg.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.kg.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.kg.bouncycastle.asn1.pkcs.PBEParameter;
import org.kg.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.kg.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.kg.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.kg.bouncycastle.jcajce.JcaJceHelper;
import org.kg.bouncycastle.jcajce.NamedJcaJceHelper;
import org.kg.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.kg.bouncycastle.openssl.PEMException;
import org.kg.bouncycastle.openssl.jcajce.PEMUtilities;
import org.kg.bouncycastle.operator.InputDecryptor;
import org.kg.bouncycastle.operator.InputDecryptorProvider;
import org.kg.bouncycastle.operator.OperatorCreationException;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            public InputDecryptor get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = PEMUtilities.generateSecretKeyForPKCS5Scheme2(oid, password, salt, iterationCount);
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(oid);
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (PEMUtilities.isPKCS12(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getIV(), params.getIterations().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getSalt(), params.getIterationCount().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(this, algorithm, cipher){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ AlgorithmIdentifier val$algorithm;
                        private final /* synthetic */ Cipher val$cipher;
                        {
                            this.this$1 = var1_1;
                            this.val$algorithm = algorithmIdentifier;
                            this.val$cipher = cipher;
                        }

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return this.val$algorithm;
                        }

                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, this.val$cipher);
                        }
                    };
                }
                catch (IOException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
            }
        };
    }
}

