/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jce.provider;

import java.security.Permission;
import javax.crypto.spec.DHParameterSpec;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.kg.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.kg.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import org.kg.bouncycastle.jce.spec.ECParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("KGBC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("KGBC", "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission("KGBC", "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission("KGBC", "DhDefaultParams");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    void setParameter(String parameterName, Object parameter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (parameterName.equals("threadLocalEcImplicitlyCa")) {
            ECParameterSpec curveSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((curveSpec = parameter instanceof ECParameterSpec || parameter == null ? (ECParameterSpec)parameter : EC5Util.convertSpec((java.security.spec.ECParameterSpec)parameter, false)) == null) {
                this.ecThreadSpec.remove();
            } else {
                this.ecThreadSpec.set(curveSpec);
            }
        } else if (parameterName.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            this.ecImplicitCaParams = parameter instanceof ECParameterSpec || parameter == null ? (ECParameterSpec)parameter : EC5Util.convertSpec((java.security.spec.ECParameterSpec)parameter, false);
        } else if (parameterName.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(parameter instanceof DHParameterSpec) && !(parameter instanceof DHParameterSpec[]) && parameter != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            Object dhSpec = parameter;
            if (dhSpec == null) {
                this.dhThreadSpec.remove();
            } else {
                this.dhThreadSpec.set(dhSpec);
            }
        } else if (parameterName.equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (parameter instanceof DHParameterSpec || parameter instanceof DHParameterSpec[] || parameter == null) {
                this.dhDefaultParams = parameter;
            } else {
                throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            }
        }
    }

    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec spec = (ECParameterSpec)this.ecThreadSpec.get();
        if (spec != null) {
            return spec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters(int keySize) {
        Object params = this.dhThreadSpec.get();
        if (params == null) {
            params = this.dhDefaultParams;
        }
        if (params instanceof DHParameterSpec) {
            DHParameterSpec spec = (DHParameterSpec)params;
            if (spec.getP().bitLength() == keySize) {
                return spec;
            }
        } else if (params instanceof DHParameterSpec[]) {
            DHParameterSpec[] specs = (DHParameterSpec[])params;
            int i = 0;
            while (i != specs.length) {
                if (specs[i].getP().bitLength() == keySize) {
                    return specs[i];
                }
                ++i;
            }
        }
        return null;
    }
}

