/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.kg.bouncycastle.crypto.BlockCipher;
import org.kg.bouncycastle.crypto.CipherKeyGenerator;
import org.kg.bouncycastle.crypto.engines.Shacal2Engine;
import org.kg.bouncycastle.crypto.modes.CBCBlockCipher;
import org.kg.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Shacal2 {
    static /* synthetic */ Class class$0;

    private Shacal2() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Shacal2 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[32];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Shacal2", "KGBC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Shacal2 IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new Shacal2Engine()), 256);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new Shacal2Engine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Shacal2", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.jcajce.provider.symmetric.Shacal2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Shacal2", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.Shacal2", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameterGenerator.Shacal2", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("AlgorithmParameters.Shacal2", String.valueOf(PREFIX) + "$AlgParams");
        }
    }
}

