/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.asymmetric.ies;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPrivateKey;
import org.kg.bouncycastle.crypto.InvalidCipherTextException;
import org.kg.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.kg.bouncycastle.crypto.digests.SHA1Digest;
import org.kg.bouncycastle.crypto.engines.IESEngine;
import org.kg.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.kg.bouncycastle.crypto.macs.HMac;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.crypto.params.IESParameters;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.DHUtil;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.kg.bouncycastle.jce.interfaces.ECPrivateKey;
import org.kg.bouncycastle.jce.interfaces.ECPublicKey;
import org.kg.bouncycastle.jce.interfaces.IESKey;
import org.kg.bouncycastle.jce.spec.IESParameterSpec;

public class CipherSpi
extends javax.crypto.CipherSpi {
    private IESEngine cipher;
    private int state = -1;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private AlgorithmParameters engineParam = null;
    private IESParameterSpec engineParams = null;
    private Class[] availableSpecs;
    static /* synthetic */ Class class$0;

    public CipherSpi(IESEngine engine) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.kg.bouncycastle.jce.spec.IESParameterSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.availableSpecs = classArray;
        this.cipher = engine;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) {
        if (!(key instanceof IESKey)) {
            throw new IllegalArgumentException("must be passed IE key");
        }
        IESKey ieKey = (IESKey)key;
        if (ieKey.getPrivate() instanceof DHPrivateKey) {
            DHPrivateKey k = (DHPrivateKey)ieKey.getPrivate();
            return k.getX().bitLength();
        }
        if (ieKey.getPrivate() instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)ieKey.getPrivate();
            return k.getD().bitLength();
        }
        throw new IllegalArgumentException("not an IE key!");
    }

    protected int engineGetOutputSize(int inputLen) {
        if (this.state == 1 || this.state == 3) {
            return this.buffer.size() + inputLen + 20;
        }
        if (this.state == 2 || this.state == 4) {
            return this.buffer.size() + inputLen - 20;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineParams != null) {
            String name = "IES";
            try {
                this.engineParam = AlgorithmParameters.getInstance(name, "KGBC");
                this.engineParam.init(this.engineParams);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParam;
    }

    protected void engineSetMode(String mode) {
        throw new IllegalArgumentException("can't support mode " + mode);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException(String.valueOf(padding) + " unavailable with RSA.");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter privKey;
        AsymmetricKeyParameter pubKey;
        if (!(key instanceof IESKey)) {
            throw new InvalidKeyException("must be passed IES key");
        }
        if (params == null && (opmode == 1 || opmode == 3)) {
            byte[] d = new byte[16];
            byte[] e = new byte[16];
            if (random == null) {
                random = new SecureRandom();
            }
            random.nextBytes(d);
            random.nextBytes(e);
            params = new IESParameterSpec(d, e, 128);
        } else if (!(params instanceof IESParameterSpec)) {
            throw new InvalidAlgorithmParameterException("must be passed IES parameters");
        }
        IESKey ieKey = (IESKey)key;
        if (ieKey.getPublic() instanceof ECPublicKey) {
            pubKey = ECUtil.generatePublicKeyParameter(ieKey.getPublic());
            privKey = ECUtil.generatePrivateKeyParameter(ieKey.getPrivate());
        } else {
            pubKey = DHUtil.generatePublicKeyParameter(ieKey.getPublic());
            privKey = DHUtil.generatePrivateKeyParameter(ieKey.getPrivate());
        }
        this.engineParams = (IESParameterSpec)params;
        IESParameters p = new IESParameters(this.engineParams.getDerivationV(), this.engineParams.getEncodingV(), this.engineParams.getMacKeySize());
        this.state = opmode;
        this.buffer.reset();
        switch (opmode) {
            case 1: 
            case 3: {
                this.cipher.init(true, privKey, pubKey, p);
                break;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, privKey, pubKey, p);
                break;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            int i = 0;
            while (i != this.availableSpecs.length) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineParam = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (opmode == 1 || opmode == 3) {
            try {
                this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("can't handle null parameter spec in IES");
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buffer.write(input, inputOffset, inputLen);
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.buffer.write(input, inputOffset, inputLen);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (inputLen != 0) {
            this.buffer.write(input, inputOffset, inputLen);
        }
        try {
            byte[] buf = this.buffer.toByteArray();
            this.buffer.reset();
            return this.cipher.processBlock(buf, 0, buf.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        if (inputLen != 0) {
            this.buffer.write(input, inputOffset, inputLen);
        }
        try {
            byte[] buf = this.buffer.toByteArray();
            this.buffer.reset();
            buf = this.cipher.processBlock(buf, 0, buf.length);
            System.arraycopy(buf, 0, output, outputOffset, buf.length);
            return buf.length;
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    public static class IES
    extends CipherSpi {
        public IES() {
            super(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest())));
        }
    }
}

