/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.asymmetric.dstu;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.kg.bouncycastle.crypto.DSA;
import org.kg.bouncycastle.crypto.Digest;
import org.kg.bouncycastle.crypto.digests.GOST3411Digest;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.crypto.params.ParametersWithRandom;
import org.kg.bouncycastle.crypto.signers.DSTU4145Signer;
import org.kg.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.kg.bouncycastle.jce.interfaces.ECKey;
import org.kg.bouncycastle.jce.interfaces.ECPublicKey;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignatureSpi
extends java.security.SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer = new DSTU4145Signer();
    private static byte[] DEFAULT_SBOX;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 10;
        byArray[1] = 9;
        byArray[2] = 13;
        byArray[3] = 6;
        byArray[4] = 14;
        byArray[5] = 11;
        byArray[6] = 4;
        byArray[7] = 5;
        byArray[8] = 15;
        byArray[9] = 1;
        byArray[10] = 3;
        byArray[11] = 12;
        byArray[12] = 7;
        byArray[14] = 8;
        byArray[15] = 2;
        byArray[16] = 8;
        byArray[18] = 12;
        byArray[19] = 4;
        byArray[20] = 9;
        byArray[21] = 6;
        byArray[22] = 7;
        byArray[23] = 11;
        byArray[24] = 2;
        byArray[25] = 3;
        byArray[26] = 1;
        byArray[27] = 15;
        byArray[28] = 5;
        byArray[29] = 14;
        byArray[30] = 10;
        byArray[31] = 13;
        byArray[32] = 15;
        byArray[33] = 6;
        byArray[34] = 5;
        byArray[35] = 8;
        byArray[36] = 14;
        byArray[37] = 11;
        byArray[38] = 10;
        byArray[39] = 4;
        byArray[40] = 12;
        byArray[42] = 3;
        byArray[43] = 7;
        byArray[44] = 2;
        byArray[45] = 9;
        byArray[46] = 1;
        byArray[47] = 13;
        byArray[48] = 3;
        byArray[49] = 8;
        byArray[50] = 13;
        byArray[51] = 9;
        byArray[52] = 6;
        byArray[53] = 11;
        byArray[54] = 15;
        byArray[56] = 2;
        byArray[57] = 5;
        byArray[58] = 12;
        byArray[59] = 10;
        byArray[60] = 4;
        byArray[61] = 14;
        byArray[62] = 1;
        byArray[63] = 7;
        byArray[64] = 15;
        byArray[65] = 8;
        byArray[66] = 14;
        byArray[67] = 9;
        byArray[68] = 7;
        byArray[69] = 2;
        byArray[71] = 13;
        byArray[72] = 12;
        byArray[73] = 6;
        byArray[74] = 1;
        byArray[75] = 5;
        byArray[76] = 11;
        byArray[77] = 4;
        byArray[78] = 3;
        byArray[79] = 10;
        byArray[80] = 2;
        byArray[81] = 8;
        byArray[82] = 9;
        byArray[83] = 7;
        byArray[84] = 5;
        byArray[85] = 15;
        byArray[87] = 11;
        byArray[88] = 12;
        byArray[89] = 1;
        byArray[90] = 13;
        byArray[91] = 14;
        byArray[92] = 10;
        byArray[93] = 3;
        byArray[94] = 6;
        byArray[95] = 4;
        byArray[96] = 3;
        byArray[97] = 8;
        byArray[98] = 11;
        byArray[99] = 5;
        byArray[100] = 6;
        byArray[101] = 4;
        byArray[102] = 14;
        byArray[103] = 10;
        byArray[104] = 2;
        byArray[105] = 12;
        byArray[106] = 1;
        byArray[107] = 7;
        byArray[108] = 9;
        byArray[109] = 15;
        byArray[110] = 13;
        byArray[112] = 1;
        byArray[113] = 2;
        byArray[114] = 3;
        byArray[115] = 14;
        byArray[116] = 6;
        byArray[117] = 13;
        byArray[118] = 11;
        byArray[119] = 8;
        byArray[120] = 15;
        byArray[121] = 10;
        byArray[122] = 12;
        byArray[123] = 5;
        byArray[124] = 7;
        byArray[125] = 9;
        byArray[127] = 4;
        DEFAULT_SBOX = byArray;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof ECPublicKey) {
            param = ECUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest = new GOST3411Digest(this.expandSbox(((BCDSTU4145PublicKey)publicKey).getSbox()));
        this.signer.init(false, param);
    }

    byte[] expandSbox(byte[] compressed) {
        byte[] expanded = new byte[128];
        int i = 0;
        while (i < compressed.length) {
            expanded[i * 2] = (byte)(compressed[i] >> 4 & 0xF);
            expanded[i * 2 + 1] = (byte)(compressed[i] & 0xF);
            ++i;
        }
        return expanded;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = null;
        if (privateKey instanceof ECKey) {
            param = ECUtil.generatePrivateKeyParameter(privateKey);
        }
        this.digest = new GOST3411Digest(DEFAULT_SBOX);
        if (this.appRandom != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.appRandom));
        } else {
            this.signer.init(true, param);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.signer.generateSignature(hash);
            byte[] r = sig[0].toByteArray();
            byte[] s = sig[1].toByteArray();
            byte[] sigBytes = new byte[r.length > s.length ? r.length * 2 : s.length * 2];
            System.arraycopy(s, 0, sigBytes, sigBytes.length / 2 - s.length, s.length);
            System.arraycopy(r, 0, sigBytes, sigBytes.length - r.length, r.length);
            return new DEROctetString(sigBytes).getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = ((ASN1OctetString)ASN1OctetString.fromByteArray(sigBytes)).getOctets();
            byte[] r = new byte[bytes.length / 2];
            byte[] s = new byte[bytes.length / 2];
            System.arraycopy(bytes, 0, s, 0, bytes.length / 2);
            System.arraycopy(bytes, bytes.length / 2, r, 0, bytes.length / 2);
            sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        }
        catch (Exception e) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

