/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kg.bouncycastle.asn1.dvcs.Data;
import org.kg.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.kg.bouncycastle.dvcs.DVCSConstructionException;
import org.kg.bouncycastle.dvcs.DVCSRequestData;
import org.kg.bouncycastle.dvcs.TargetChain;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] certs = data.getCerts();
        if (certs == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(certs.length);
        int i = 0;
        while (i != certs.length) {
            this.chains.add(new TargetChain(certs[i]));
            ++i;
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

