/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.util;

import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.DERNull;
import org.kg.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.kg.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.kg.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.kg.bouncycastle.asn1.sec.ECPrivateKey;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.asn1.x509.DSAParameter;
import org.kg.bouncycastle.asn1.x9.X962Parameters;
import org.kg.bouncycastle.asn1.x9.X9ECParameters;
import org.kg.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.crypto.params.DSAParameters;
import org.kg.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ECDomainParameters;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.RSAKeyParameters;
import org.kg.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyInfoFactory {
    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getExponent(), priv.getP(), priv.getQ(), priv.getDP(), priv.getDQ(), priv.getQInv()));
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)privateKey;
            DSAParameters params = priv.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(params.getP(), params.getQ(), params.getG())), new ASN1Integer(priv.getX()));
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            X962Parameters params;
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters domainParams = priv.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
            }
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), new ECPrivateKey(priv.getD(), params));
        }
        throw new IOException("key parameters not recognised.");
    }
}

