/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.kg.bouncycastle.crypto.Digest;
import org.kg.bouncycastle.crypto.tls.AbstractTlsContext;
import org.kg.bouncycastle.crypto.tls.ByteQueue;
import org.kg.bouncycastle.crypto.tls.Certificate;
import org.kg.bouncycastle.crypto.tls.ProtocolVersion;
import org.kg.bouncycastle.crypto.tls.RecordStream;
import org.kg.bouncycastle.crypto.tls.SecurityParameters;
import org.kg.bouncycastle.crypto.tls.SessionParameters;
import org.kg.bouncycastle.crypto.tls.SupplementalDataEntry;
import org.kg.bouncycastle.crypto.tls.TlsContext;
import org.kg.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.kg.bouncycastle.crypto.tls.TlsFatalAlert;
import org.kg.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.kg.bouncycastle.crypto.tls.TlsInputStream;
import org.kg.bouncycastle.crypto.tls.TlsKeyExchange;
import org.kg.bouncycastle.crypto.tls.TlsOutputStream;
import org.kg.bouncycastle.crypto.tls.TlsPeer;
import org.kg.bouncycastle.crypto.tls.TlsSession;
import org.kg.bouncycastle.crypto.tls.TlsSessionImpl;
import org.kg.bouncycastle.crypto.tls.TlsUtils;
import org.kg.bouncycastle.util.Arrays;
import org.kg.bouncycastle.util.Integers;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_CERTIFICATE_STATUS = 5;
    protected static final short CS_SERVER_KEY_EXCHANGE = 6;
    protected static final short CS_CERTIFICATE_REQUEST = 7;
    protected static final short CS_SERVER_HELLO_DONE = 8;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 9;
    protected static final short CS_CLIENT_CERTIFICATE = 10;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 11;
    protected static final short CS_CERTIFICATE_VERIFY = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_FINISHED = 15;
    protected static final short CS_END = 16;
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue(2);
    private ByteQueue handshakeQueue = new ByteQueue();
    protected RecordStream recordStream;
    protected SecureRandom secureRandom;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failedWithError = false;
    private volatile boolean appDataReady = false;
    private volatile boolean splitApplicationDataRecords = true;
    private byte[] expected_verify_data = null;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected SecurityParameters securityParameters = null;
    protected Certificate peerCertificate = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean resumedSession = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean secure_renegotiation = false;
    protected boolean allowCertificateStatus = false;
    protected boolean expectSessionTicket = false;

    public TlsProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        this.recordStream = new RecordStream(this, input, output);
        this.secureRandom = secureRandom;
    }

    protected abstract AbstractTlsContext getContext();

    protected abstract TlsPeer getPeer();

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected abstract void handleHandshakeMessage(short var1, byte[] var2) throws IOException;

    protected void handleWarningMessage(short description) throws IOException {
    }

    protected void cleanupHandshake() {
        if (this.expected_verify_data != null) {
            Arrays.fill(this.expected_verify_data, (byte)0);
            this.expected_verify_data = null;
        }
        this.securityParameters.clear();
        this.peerCertificate = null;
        this.offeredCipherSuites = null;
        this.offeredCompressionMethods = null;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.resumedSession = false;
        this.receivedChangeCipherSpec = false;
        this.secure_renegotiation = false;
        this.allowCertificateStatus = false;
        this.expectSessionTicket = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void completeHandshake() throws IOException {
        try {
            while (true) {
                if (this.connection_state == 16) {
                    this.recordStream.finaliseHandshake();
                    boolean bl = this.splitApplicationDataRecords = !TlsUtils.isTLSv11(this.getContext());
                }
                this.safeReadRecord();
            }
            if (!this.appDataReady) {
                this.appDataReady = true;
                this.tlsInputStream = new TlsInputStream(this);
                this.tlsOutputStream = new TlsOutputStream(this);
            }
            if (this.tlsSession != null) {
                if (this.sessionParameters == null) {
                    this.sessionParameters = new SessionParameters.Builder().setCipherSuite(this.securityParameters.cipherSuite).setCompressionAlgorithm(this.securityParameters.compressionAlgorithm).setMasterSecret(this.securityParameters.masterSecret).setPeerCertificate(this.peerCertificate).setServerExtensions(this.serverExtensions).build();
                    this.tlsSession = new TlsSessionImpl(this.tlsSession.getSessionID(), this.sessionParameters);
                }
                this.getContext().setResumableSession(this.tlsSession);
            }
            this.getPeer().notifyHandshakeComplete();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.cleanupHandshake();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.cleanupHandshake();
            return;
        }
    }

    protected void processRecord(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
                break;
            }
            case 20: {
                this.processChangeCipherSpec(buf, offset, len);
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = this.handshakeQueue.removeData(len, 4);
            switch (type) {
                case 0: {
                    break;
                }
                case 20: {
                    if (this.expected_verify_data == null) {
                        this.expected_verify_data = this.createVerifyData(!this.getContext().isServer());
                    }
                }
                default: {
                    this.recordStream.updateHandshakeData(beginning, 0, 4);
                    this.recordStream.updateHandshakeData(buf, 0, len);
                }
            }
            this.handleHandshakeMessage(type, buf);
            read = true;
        } while (read);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = this.alertQueue.removeData(2, 0);
            byte level = tmp[0];
            byte description = tmp[1];
            this.getPeer().notifyAlertReceived(level, description);
            if (level == 2) {
                this.invalidateSession();
                this.failedWithError = true;
                this.closed = true;
                this.recordStream.safeClose();
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description == 0) {
                this.handleClose(false);
            }
            this.handleWarningMessage(description);
        }
    }

    private void processChangeCipherSpec(byte[] buf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            short message = TlsUtils.readUint8(buf, off + i);
            if (message != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec) {
                throw new TlsFatalAlert(10);
            }
            this.receivedChangeCipherSpec = true;
            this.recordStream.receivedReadCipherSpec();
            this.handleChangeCipherSpecMessage();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len >= 1) ** GOTO lbl8
        return 0;
lbl-1000:
        // 1 sources

        {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException("Internal TLS error, this could be an attack");
                }
                return -1;
            }
            this.safeReadRecord();
lbl8:
            // 2 sources

            ** while (this.applicationDataQueue.size() == 0)
        }
lbl9:
        // 1 sources

        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.removeData(buf, offset, len, 0);
        return len;
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (!this.recordStream.readRecord()) {
                throw new EOFException();
            }
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription(), "Failed to read record", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to read record", e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to read record", e);
            }
            throw e;
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.recordStream.writeRecord(type, buf, offset, len);
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription(), "Failed to write record", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to write record", e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to write record", e);
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        if (!this.closed) ** GOTO lbl14
        if (this.failedWithError) {
            throw new IOException("Internal TLS error, this could be an attack");
        }
        throw new IOException("Sorry, connection has been closed, you cannot write more data");
lbl-1000:
        // 1 sources

        {
            if (this.splitApplicationDataRecords) {
                this.safeWriteRecord((short)23, buf, offset, 1);
                ++offset;
                --len;
            }
            if (len <= 0) continue;
            toWrite = Math.min(len, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)23, buf, offset, toWrite);
            offset += toWrite;
            len -= toWrite;
lbl14:
            // 3 sources

            ** while (len > 0)
        }
lbl15:
        // 1 sources

    }

    protected void writeHandshakeMessage(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int toWrite = Math.min(len, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)22, buf, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short alertLevel, short alertDescription, String message, Exception cause) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (alertLevel == 2) {
                this.invalidateSession();
                this.failedWithError = true;
            }
            this.raiseAlert(alertLevel, alertDescription, message, cause);
            this.recordStream.safeClose();
            if (alertLevel != 2) {
                return;
            }
        }
        throw new IOException(TLS_ERROR_MESSAGE);
    }

    protected void invalidateSession() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
            this.tlsSession = null;
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        byte[] verify_data = TlsUtils.readFully(this.expected_verify_data.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual(this.expected_verify_data, verify_data)) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void raiseAlert(short alertLevel, short alertDescription, String message, Exception cause) throws IOException {
        this.getPeer().notifyAlertRaised(alertLevel, alertDescription, message, cause);
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.safeWriteRecord((short)21, error, 0, 2);
    }

    protected void raiseWarning(short alertDescription, String message) throws IOException {
        this.raiseAlert((short)1, alertDescription, message, null);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        ProtocolVersion serverVersion;
        AbstractTlsContext context;
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.getLength() == 0 && !(context = this.getContext()).isServer() && (serverVersion = this.getContext().getServerVersion()).isSSL()) {
            String message = String.valueOf(serverVersion.toString()) + " client didn't provide credentials";
            this.raiseWarning((short)41, message);
            return;
        }
        HandshakeMessage message = new HandshakeMessage(11);
        certificate.encode(message);
        message.writeToRecordStream();
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] message = new byte[]{1};
        this.safeWriteRecord((short)20, message, 0, message.length);
        this.recordStream.sentWriteCipherSpec();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] verify_data = this.createVerifyData(this.getContext().isServer());
        HandshakeMessage message = new HandshakeMessage(20, verify_data.length);
        message.write(verify_data);
        message.writeToRecordStream();
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        HandshakeMessage message = new HandshakeMessage(23);
        TlsProtocol.writeSupplementalData(message, supplementalData);
        message.writeToRecordStream();
    }

    protected byte[] createVerifyData(boolean isServer) {
        AbstractTlsContext context = this.getContext();
        if (isServer) {
            return TlsUtils.calculateVerifyData(context, "server finished", TlsProtocol.getCurrentPRFHash(this.getContext(), this.recordStream.getHandshakeHash(), TlsUtils.SSL_SERVER));
        }
        return TlsUtils.calculateVerifyData(context, "client finished", TlsProtocol.getCurrentPRFHash(this.getContext(), this.recordStream.getHandshakeHash(), TlsUtils.SSL_CLIENT));
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.closed) {
            if (user_canceled && !this.appDataReady) {
                this.raiseWarning((short)90, "User canceled handshake");
            }
            this.failWithError((short)1, (short)0, "Connection closed", null);
        }
    }

    protected void flush() throws IOException {
        this.recordStream.flush();
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short maxFragmentLength = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (maxFragmentLength >= 0 && !this.resumedSession && maxFragmentLength != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions)) {
            throw new TlsFatalAlert(alertDescription);
        }
        return maxFragmentLength;
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(SecureRandom random) {
        random.setSeed(System.currentTimeMillis());
        byte[] result = new byte[32];
        random.nextBytes(result);
        return result;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    /*
     * Exception decompiling
     */
    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 44->48)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static byte[] getCurrentPRFHash(TlsContext context, TlsHandshakeHash handshakeHash, byte[] sslSender) {
        Digest d = handshakeHash.forkPRFHash();
        if (sslSender != null && TlsUtils.isSSL(context)) {
            d.update(sslSender, 0, sslSender.length);
        }
        byte[] bs = new byte[d.getDigestSize()];
        d.doFinal(bs, 0);
        return bs;
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] extBytes = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(extBytes);
        Hashtable<Integer, byte[]> extensions = new Hashtable<Integer, byte[]>();
        while (buf.available() > 0) {
            byte[] extension_data;
            Integer extension_type = Integers.valueOf(TlsUtils.readUint16(buf));
            if (extensions.put(extension_type, extension_data = TlsUtils.readOpaque16(buf)) == null) continue;
            throw new TlsFatalAlert(47);
        }
        return extensions;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] supp_data = TlsUtils.readOpaque24(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(supp_data);
        Vector<SupplementalDataEntry> supplementalData = new Vector<SupplementalDataEntry>();
        while (buf.available() > 0) {
            int supp_data_type = TlsUtils.readUint16(buf);
            byte[] data = TlsUtils.readOpaque16(buf);
            supplementalData.addElement(new SupplementalDataEntry(supp_data_type, data));
        }
        return supplementalData;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Enumeration keys = extensions.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            int extension_type = key;
            byte[] extension_data = (byte[])extensions.get(key);
            TlsUtils.checkUint16(extension_type);
            TlsUtils.writeUint16(extension_type, buf);
            TlsUtils.writeOpaque16(extension_data, buf);
        }
        byte[] extBytes = buf.toByteArray();
        TlsUtils.writeOpaque16(extBytes, output);
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int i = 0;
        while (i < supplementalData.size()) {
            SupplementalDataEntry entry = (SupplementalDataEntry)supplementalData.elementAt(i);
            int supp_data_type = entry.getDataType();
            TlsUtils.checkUint16(supp_data_type);
            TlsUtils.writeUint16(supp_data_type, buf);
            TlsUtils.writeOpaque16(entry.getData(), buf);
            ++i;
        }
        byte[] supp_data = buf.toByteArray();
        TlsUtils.writeOpaque24(supp_data, output);
    }

    protected static int getPRFAlgorithm(TlsContext context, int ciphersuite) throws IOException {
        boolean isTLSv12 = TlsUtils.isTLSv12(context);
        switch (ciphersuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 170: 
            case 172: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: {
                if (isTLSv12) {
                    return 1;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: {
                if (isTLSv12) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: {
                if (isTLSv12) {
                    return 2;
                }
                return 0;
            }
        }
        if (isTLSv12) {
            return 1;
        }
        return 0;
    }

    class HandshakeMessage
    extends ByteArrayOutputStream {
        HandshakeMessage(short handshakeType) throws IOException {
            this(handshakeType, 60);
        }

        HandshakeMessage(short handshakeType, int length) throws IOException {
            super(length + 4);
            TlsUtils.writeUint8(handshakeType, (OutputStream)this);
            this.count += 3;
        }

        void writeToRecordStream() throws IOException {
            int length = this.count - 4;
            TlsUtils.checkUint24(length);
            TlsUtils.writeUint24(length, this.buf, 1);
            TlsProtocol.this.writeHandshakeMessage(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

