/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.kg.bouncycastle.crypto.Digest;
import org.kg.bouncycastle.crypto.Signer;
import org.kg.bouncycastle.crypto.params.DHParameters;
import org.kg.bouncycastle.crypto.tls.CombinedHash;
import org.kg.bouncycastle.crypto.tls.DigestInputBuffer;
import org.kg.bouncycastle.crypto.tls.DigitallySigned;
import org.kg.bouncycastle.crypto.tls.SecurityParameters;
import org.kg.bouncycastle.crypto.tls.ServerDHParams;
import org.kg.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.kg.bouncycastle.crypto.tls.SignerInputBuffer;
import org.kg.bouncycastle.crypto.tls.TlsCredentials;
import org.kg.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.kg.bouncycastle.crypto.tls.TlsDHUtils;
import org.kg.bouncycastle.crypto.tls.TlsFatalAlert;
import org.kg.bouncycastle.crypto.tls.TlsSigner;
import org.kg.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.kg.bouncycastle.crypto.tls.TlsUtils;
import org.kg.bouncycastle.util.io.TeeInputStream;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms, dhParameters);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        Digest d;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer buf = new DigestInputBuffer();
        this.dhAgreeServerPrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, buf);
        if (TlsUtils.isTLSv12(this.context)) {
            signatureAndHashAlgorithm = this.serverCredentials.getSignatureAndHashAlgorithm();
            if (signatureAndHashAlgorithm == null) {
                throw new TlsFatalAlert(80);
            }
            d = TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
        } else {
            signatureAndHashAlgorithm = null;
            d = new CombinedHash();
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(d);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
        DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
        signed_params.encode(buf);
        return buf.toByteArray();
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = new SignerInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        ServerDHParams params = ServerDHParams.parse(teeIn);
        DigitallySigned signed_params = DigitallySigned.parse(this.context, input);
        Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
        buf.updateSigner(signer);
        if (!signer.verifySignature(signed_params.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreeServerPublicKey = TlsDHUtils.validateDHPublicKey(params.getPublicKey());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

