/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.kg.bouncycastle.crypto.tls.Certificate;
import org.kg.bouncycastle.crypto.tls.TlsProtocol;
import org.kg.bouncycastle.util.Arrays;

public final class SessionParameters {
    private int cipherSuite;
    private short compressionAlgorithm;
    private byte[] masterSecret;
    private Certificate peerCertificate;
    private byte[] encodedServerExtensions;

    private SessionParameters(int cipherSuite, short compressionAlgorithm, byte[] masterSecret, Certificate peerCertificate, byte[] encodedServerExtensions) {
        this.cipherSuite = cipherSuite;
        this.compressionAlgorithm = compressionAlgorithm;
        this.masterSecret = Arrays.clone(masterSecret);
        this.peerCertificate = peerCertificate;
        this.encodedServerExtensions = encodedServerExtensions;
    }

    public void clear() {
        if (this.masterSecret != null) {
            Arrays.fill(this.masterSecret, (byte)0);
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.cipherSuite, this.compressionAlgorithm, this.masterSecret, this.peerCertificate, this.encodedServerExtensions);
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public short getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public Certificate getPeerCertificate() {
        return this.peerCertificate;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.encodedServerExtensions == null) {
            return null;
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(this.encodedServerExtensions);
        return TlsProtocol.readExtensions(buf);
    }

    /* synthetic */ SessionParameters(int n, short s, byte[] byArray, Certificate certificate, byte[] byArray2, SessionParameters sessionParameters) {
        this(n, s, byArray, certificate, byArray2);
    }

    public static final class Builder {
        private int cipherSuite = -1;
        private short compressionAlgorithm = (short)-1;
        private byte[] masterSecret = null;
        private Certificate peerCertificate = null;
        private byte[] encodedServerExtensions = null;

        public SessionParameters build() {
            this.validate(this.cipherSuite >= 0, "cipherSuite");
            this.validate(this.compressionAlgorithm >= 0, "compressionAlgorithm");
            this.validate(this.masterSecret != null, "masterSecret");
            return new SessionParameters(this.cipherSuite, this.compressionAlgorithm, this.masterSecret, this.peerCertificate, this.encodedServerExtensions, null);
        }

        public Builder setCipherSuite(int cipherSuite) {
            this.cipherSuite = cipherSuite;
            return this;
        }

        public Builder setCompressionAlgorithm(short compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public Builder setMasterSecret(byte[] masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder setPeerCertificate(Certificate peerCertificate) {
            this.peerCertificate = peerCertificate;
            return this;
        }

        public Builder setServerExtensions(Hashtable serverExtensions) throws IOException {
            if (serverExtensions == null) {
                this.encodedServerExtensions = null;
            } else {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(buf, serverExtensions);
                this.encodedServerExtensions = buf.toByteArray();
            }
            return this;
        }

        private void validate(boolean condition, String parameter) {
            if (!condition) {
                throw new IllegalStateException("Required session parameter '" + parameter + "' not configured");
            }
        }
    }
}

