/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.prng;

import java.security.SecureRandom;
import org.kg.bouncycastle.crypto.prng.EntropySource;
import org.kg.bouncycastle.crypto.prng.EntropySourceProvider;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this._sr = random;
        this._predictionResistant = isPredictionResistant;
    }

    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                return BasicEntropySourceProvider.this._sr.generateSeed((bitsRequired + 7) / 8);
            }

            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

