/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.kg.bouncycastle.crypto.InvalidCipherTextException;
import org.kg.bouncycastle.crypto.paddings.BlockCipherPadding;

public class ZeroBytePadding
implements BlockCipherPadding {
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "ZeroByte";
    }

    public int addPadding(byte[] in, int inOff) {
        int added = in.length - inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return added;
    }

    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in.length;
        while (count > 0) {
            if (in[count - 1] != 0) break;
            --count;
        }
        return in.length - count;
    }
}

