/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.kg.bouncycastle.crypto.InvalidCipherTextException;
import org.kg.bouncycastle.crypto.paddings.BlockCipherPadding;

public class TBCPadding
implements BlockCipherPadding {
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "TBC";
    }

    public int addPadding(byte[] in, int inOff) {
        int count = in.length - inOff;
        byte code = inOff > 0 ? (byte)((in[inOff - 1] & 1) == 0 ? 255 : 0) : (byte)((in[in.length - 1] & 1) == 0 ? 255 : 0);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return count;
    }

    public int padCount(byte[] in) throws InvalidCipherTextException {
        byte code = in[in.length - 1];
        int index = in.length - 1;
        while (index > 0 && in[index - 1] == code) {
            --index;
        }
        return in.length - index;
    }
}

