/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.kg.bouncycastle.crypto.BufferedBlockCipher;
import org.kg.bouncycastle.crypto.InvalidCipherTextException;
import org.kg.bouncycastle.crypto.StreamCipher;
import org.kg.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.kg.bouncycastle.crypto.modes.AEADBlockCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream os, BufferedBlockCipher cipher) {
        super(os);
        this.bufferedBlockCipher = cipher;
    }

    public CipherOutputStream(OutputStream os, StreamCipher cipher) {
        super(os);
        this.streamCipher = cipher;
    }

    public CipherOutputStream(OutputStream os, AEADBlockCipher cipher) {
        super(os);
        this.aeadBlockCipher = cipher;
    }

    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)b));
        } else {
            this.write(this.oneByte, 0, 1);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        if (this.bufferedBlockCipher != null) {
            int outLen = this.bufferedBlockCipher.processBytes(b, off, len, this.buf, 0);
            if (outLen != 0) {
                this.out.write(this.buf, 0, outLen);
            }
        } else if (this.aeadBlockCipher != null) {
            int outLen = this.aeadBlockCipher.processBytes(b, off, len, this.buf, 0);
            if (outLen != 0) {
                this.out.write(this.buf, 0, outLen);
            }
        } else {
            this.streamCipher.processBytes(b, off, len, this.buf, 0);
            this.out.write(this.buf, 0, len);
        }
    }

    private void ensureCapacity(int outputSize) {
        int bufLen = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.getOutputSize(outputSize) : (this.aeadBlockCipher != null ? this.aeadBlockCipher.getOutputSize(outputSize) : outputSize);
        if (this.buf == null || this.buf.length < bufLen) {
            this.buf = new byte[bufLen];
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        IOException error;
        block10: {
            this.ensureCapacity(0);
            error = null;
            try {
                int outLen;
                if (this.bufferedBlockCipher != null) {
                    int outLen2 = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (outLen2 != 0) {
                        this.out.write(this.buf, 0, outLen2);
                    }
                } else if (this.aeadBlockCipher != null && (outLen = this.aeadBlockCipher.doFinal(this.buf, 0)) != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
            }
            catch (InvalidCipherTextException e) {
                error = new InvalidCipherTextIOException("Error finalising cipher data", e);
            }
            catch (Exception e) {
                error = new IOException("Error closing stream: " + e);
            }
            try {
                this.flush();
                this.out.close();
            }
            catch (IOException e) {
                if (error != null) break block10;
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

