/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.RecipientOperator;
import org.kg.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import org.kg.bouncycastle.jcajce.io.MacOutputStream;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.MacCalculator;
import org.kg.bouncycastle.operator.jcajce.JceGenericKey;

public class JceKeyAgreeAuthenticatedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeAuthenticatedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, SubjectPublicKeyInfo senderPublicKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, senderPublicKey, userKeyingMaterial, encryptedContentKey);
        final Mac dataMac = this.contentHelper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            public GenericKey getKey() {
                return new JceGenericKey(contentMacAlgorithm, secretKey);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

