/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Enumeration;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1Set;
import org.kg.bouncycastle.asn1.cms.OriginatorInfo;
import org.kg.bouncycastle.asn1.x509.Certificate;
import org.kg.bouncycastle.asn1.x509.CertificateList;
import org.kg.bouncycastle.cert.X509CRLHolder;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.util.CollectionStore;
import org.kg.bouncycastle.util.Store;

public class OriginatorInformation {
    private OriginatorInfo originatorInfo;

    OriginatorInformation(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public Store getCertificates() {
        ASN1Set certSet = this.originatorInfo.getCertificates();
        if (certSet != null) {
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                certList.add(new X509CertificateHolder(Certificate.getInstance(obj)));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() {
        ASN1Set crlSet = this.originatorInfo.getCRLs();
        if (crlSet != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>(crlSet.size());
            Enumeration en = crlSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                crlList.add(new X509CRLHolder(CertificateList.getInstance(obj)));
            }
            return new CollectionStore(crlList);
        }
        return new CollectionStore(new ArrayList());
    }

    public OriginatorInfo toASN1Structure() {
        return this.originatorInfo;
    }
}

