/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.util.ArrayList;
import java.util.List;
import org.kg.bouncycastle.asn1.cms.OriginatorInfo;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSUtils;
import org.kg.bouncycastle.cms.OriginatorInformation;
import org.kg.bouncycastle.util.Store;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder origCert) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(origCert.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store origCerts) throws CMSException {
        this(origCerts, null);
    }

    public OriginatorInfoGenerator(Store origCerts, Store origCRLs) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(origCerts);
        this.origCRLs = origCRLs != null ? CMSUtils.getCRLsFromStore(origCRLs) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

