/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.kg.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.kg.bouncycastle.asn1.cms.RecipientIdentifier;
import org.kg.bouncycastle.asn1.cms.RecipientInfo;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.RecipientInfoGenerator;
import org.kg.bouncycastle.operator.AsymmetricKeyWrapper;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(encryptedKeyBytes)));
    }
}

