/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.IOException;
import org.kg.bouncycastle.asn1.cms.KEKIdentifier;
import org.kg.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cms.AuthAttributesProvider;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSSecureReadable;
import org.kg.bouncycastle.cms.KEKRecipient;
import org.kg.bouncycastle.cms.KEKRecipientId;
import org.kg.bouncycastle.cms.Recipient;
import org.kg.bouncycastle.cms.RecipientInformation;
import org.kg.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

