/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Set;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSet;
import org.kg.bouncycastle.asn1.cms.Attribute;
import org.kg.bouncycastle.asn1.cms.AttributeTable;
import org.kg.bouncycastle.asn1.cms.CMSAttributes;
import org.kg.bouncycastle.asn1.cms.Time;
import org.kg.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        ASN1ObjectIdentifier contentType;
        Hashtable std = DefaultSignedAttributeTableGenerator.copyHashTable(this.table);
        if (!std.containsKey(CMSAttributes.contentType) && (contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"))) != null) {
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.signingTime)) {
            Date signingTime = new Date();
            attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new Time(signingTime)));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }

    private static Hashtable copyHashTable(Hashtable paramsMap) {
        Hashtable newTable = new Hashtable();
        Enumeration keys = paramsMap.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            newTable.put(key, paramsMap.get(key));
        }
        return newTable;
    }
}

