/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Set;
import org.kg.bouncycastle.asn1.BEROctetString;
import org.kg.bouncycastle.asn1.DERSet;
import org.kg.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.SignedData;
import org.kg.bouncycastle.asn1.cms.SignerInfo;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSProcessable;
import org.kg.bouncycastle.cms.CMSProcessableByteArray;
import org.kg.bouncycastle.cms.CMSSignedData;
import org.kg.bouncycastle.cms.CMSSignedGenerator;
import org.kg.bouncycastle.cms.CMSSignedHelper;
import org.kg.bouncycastle.cms.CMSTypedData;
import org.kg.bouncycastle.cms.CMSUtils;
import org.kg.bouncycastle.cms.SignerInfoGenerator;
import org.kg.bouncycastle.cms.SignerInformation;
import org.kg.bouncycastle.cms.SignerInformationStore;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        Iterator it = this._signers.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BEROctetString octs = null;
        if (content != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = new BEROctetString(bOut.toByteArray());
            }
        }
        Iterator it2 = this.signerGens.iterator();
        while (it2.hasNext()) {
            SignerInfoGenerator sGen = (SignerInfoGenerator)it2.next();
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }
}

