/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSProcessable;
import org.kg.bouncycastle.cms.CMSReadable;
import org.kg.bouncycastle.util.io.Streams;

class CMSProcessableInputStream
implements CMSProcessable,
CMSReadable {
    private InputStream input;
    private boolean used = false;

    public CMSProcessableInputStream(InputStream input) {
        this.input = input;
    }

    public InputStream getInputStream() {
        this.checkSingleUsage();
        return this.input;
    }

    public void write(OutputStream zOut) throws IOException, CMSException {
        this.checkSingleUsage();
        Streams.pipeAll(this.input, zOut);
        this.input.close();
    }

    public Object getContent() {
        return this.getInputStream();
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStream can only be used once");
        }
        this.used = true;
    }
}

