/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.DigestedData;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSProcessable;
import org.kg.bouncycastle.cms.CMSProcessableByteArray;
import org.kg.bouncycastle.cms.CMSUtils;
import org.kg.bouncycastle.operator.DigestCalculator;
import org.kg.bouncycastle.operator.DigestCalculatorProvider;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.util.Arrays;

public class CMSDigestedData {
    private ContentInfo contentInfo;
    private DigestedData digestedData;

    public CMSDigestedData(byte[] compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSDigestedData(InputStream compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSDigestedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.digestedData = DigestedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestedData.getDigestAlgorithm();
    }

    public CMSProcessable getDigestedContent() throws CMSException {
        ContentInfo content = this.digestedData.getEncapContentInfo();
        try {
            return new CMSProcessableByteArray(content.getContentType(), ((ASN1OctetString)content.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new CMSException("exception reading digested stream.", e);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verify(DigestCalculatorProvider calculatorProvider) throws CMSException {
        try {
            ContentInfo content = this.digestedData.getEncapContentInfo();
            DigestCalculator calc = calculatorProvider.get(this.digestedData.getDigestAlgorithm());
            OutputStream dOut = calc.getOutputStream();
            dOut.write(((ASN1OctetString)content.getContent()).getOctets());
            return Arrays.areEqual(this.digestedData.getDigest(), calc.getDigest());
        }
        catch (OperatorCreationException e) {
            throw new CMSException("unable to create digest calculator: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CMSException("unable process content: " + e.getMessage(), e);
        }
    }
}

