/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.kg.bouncycastle.asn1.ASN1OctetStringParser;
import org.kg.bouncycastle.asn1.ASN1SequenceParser;
import org.kg.bouncycastle.asn1.cms.CompressedDataParser;
import org.kg.bouncycastle.asn1.cms.ContentInfoParser;
import org.kg.bouncycastle.cms.CMSContentInfoParser;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSTypedStream;
import org.kg.bouncycastle.operator.InputExpander;
import org.kg.bouncycastle.operator.InputExpanderProvider;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] compressedData) throws CMSException {
        this(new ByteArrayInputStream(compressedData));
    }

    public CMSCompressedDataParser(InputStream compressedData) throws CMSException {
        super(compressedData);
    }

    public CMSTypedStream getContent(InputExpanderProvider expanderProvider) throws CMSException {
        try {
            CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser content = comData.getEncapContentInfo();
            InputExpander expander = expanderProvider.get(comData.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
            return new CMSTypedStream(content.getContentType().getId(), expander.getInputStream(bytes.getOctetStream()));
        }
        catch (IOException e) {
            throw new CMSException("IOException reading compressed content.", e);
        }
    }
}

