/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cert.path.validations;

import java.util.Collection;
import java.util.Iterator;
import org.kg.bouncycastle.asn1.x500.X500Name;
import org.kg.bouncycastle.cert.X509CRLHolder;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cert.path.CertPathValidation;
import org.kg.bouncycastle.cert.path.CertPathValidationContext;
import org.kg.bouncycastle.cert.path.CertPathValidationException;
import org.kg.bouncycastle.util.Memoable;
import org.kg.bouncycastle.util.Selector;
import org.kg.bouncycastle.util.Store;

public class CRLValidation
implements CertPathValidation {
    private Store crls;
    private X500Name workingIssuerName;

    public CRLValidation(X500Name trustAnchorName, Store crls) {
        this.workingIssuerName = trustAnchorName;
        this.crls = crls;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        Collection matches = this.crls.getMatches(new Selector(){

            public boolean match(Object obj) {
                X509CRLHolder crl = (X509CRLHolder)obj;
                return crl.getIssuer().equals(CRLValidation.this.workingIssuerName);
            }

            public Object clone() {
                return this;
            }
        });
        if (matches.isEmpty()) {
            throw new CertPathValidationException("CRL for " + this.workingIssuerName + " not found");
        }
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            X509CRLHolder crl = (X509CRLHolder)it.next();
            if (crl.getRevokedCertificate(certificate.getSerialNumber()) == null) continue;
            throw new CertPathValidationException("Certificate revoked");
        }
        this.workingIssuerName = certificate.getSubject();
    }

    public Memoable copy() {
        return new CRLValidation(this.workingIssuerName, this.crls);
    }

    public void reset(Memoable other) {
        CRLValidation v = (CRLValidation)other;
        this.workingIssuerName = v.workingIssuerName;
        this.crls = v.crls;
    }
}

