/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.kg.bouncycastle.asn1.cmp.PBMParameter;
import org.kg.bouncycastle.asn1.crmf.PKMACValue;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.cert.crmf.CRMFException;
import org.kg.bouncycastle.cert.crmf.PKMACBuilder;
import org.kg.bouncycastle.operator.MacCalculator;
import org.kg.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.areEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

