/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cert.crmf;

import java.io.IOException;
import org.kg.bouncycastle.asn1.cms.EnvelopedData;
import org.kg.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import org.kg.bouncycastle.asn1.crmf.EncKeyWithID;
import org.kg.bouncycastle.asn1.crmf.EncryptedKey;
import org.kg.bouncycastle.asn1.crmf.PKIArchiveOptions;
import org.kg.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.kg.bouncycastle.asn1.x509.GeneralName;
import org.kg.bouncycastle.cert.crmf.PKIArchiveControl;
import org.kg.bouncycastle.cms.CMSEnvelopedData;
import org.kg.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.CMSProcessableByteArray;
import org.kg.bouncycastle.cms.RecipientInfoGenerator;
import org.kg.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

