/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cert.cmp;

import org.kg.bouncycastle.asn1.cmp.CertConfirmContent;
import org.kg.bouncycastle.asn1.cmp.CertStatus;
import org.kg.bouncycastle.cert.cmp.CertificateStatus;
import org.kg.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.kg.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CertificateConfirmationContent {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertConfirmContent content;

    public CertificateConfirmationContent(CertConfirmContent content) {
        this(content, new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContent(CertConfirmContent content, DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
        this.content = content;
    }

    public CertConfirmContent toASN1Structure() {
        return this.content;
    }

    public CertificateStatus[] getStatusMessages() {
        CertStatus[] statusArray = this.content.toCertStatusArray();
        CertificateStatus[] ret = new CertificateStatus[statusArray.length];
        int i = 0;
        while (i != ret.length) {
            ret[i] = new CertificateStatus(this.digestAlgFinder, statusArray[i]);
            ++i;
        }
        return ret;
    }
}

