/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava18.com.google.common.base.Strings;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.TableSource;

@Internal
public abstract class FlinkPreparingTableBase
extends Prepare.AbstractPreparingTable {
    private static final double DEFAULT_ROWCOUNT = 1.0E8;
    @Nullable
    protected final RelOptSchema relOptSchema;
    protected final RelDataType rowType;
    protected final List<String> names;
    protected FlinkStatistic statistic;

    public FlinkPreparingTableBase(@Nullable RelOptSchema relOptSchema, RelDataType rowType, Iterable<String> names, FlinkStatistic statistic) {
        this.relOptSchema = relOptSchema;
        this.rowType = Objects.requireNonNull(rowType);
        this.names = (List)Objects.requireNonNull(ImmutableList.copyOf(names));
        this.statistic = Objects.requireNonNull(statistic);
    }

    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        return LogicalTableScan.create(context.getCluster(), this, context.getTableHints());
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return false;
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public double getRowCount() {
        Double rowCnt = this.getStatistic().getRowCount();
        return rowCnt == null ? 1.0E8 : rowCnt;
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.relOptSchema;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return ImmutableList.of();
    }

    @Override
    public RelDistribution getDistribution() {
        return null;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return false;
    }

    @Override
    public List<RelReferentialConstraint> getReferentialConstraints() {
        return ImmutableList.of();
    }

    @Override
    public <C> C unwrap(Class<C> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public boolean columnHasDefaultValue(RelDataType rowType, int ordinal, InitializerContext initializerContext) {
        return false;
    }

    @Override
    public Expression getExpression(Class clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RelOptTable extend(Table extendedTable) {
        throw new RuntimeException("Extending column not supported");
    }

    protected List<String> explainSourceAsString(TableSource<?> ts) {
        String tsDigest = ts.explainSource();
        if (!Strings.isNullOrEmpty((String)tsDigest)) {
            return ImmutableList.builder().addAll(Util.skipLast(this.names)).add((Object)String.format("%s, source: [%s]", Util.last(this.names), tsDigest)).build();
        }
        return this.names;
    }

    @Override
    public List<ImmutableBitSet> getKeys() {
        return this.statistic.getKeys();
    }

    public Optional<Set<ImmutableBitSet>> uniqueKeysSet() {
        Set<? extends Set<String>> uniqueKeys = this.statistic.getUniqueKeys();
        if (uniqueKeys == null) {
            return Optional.empty();
        }
        if (uniqueKeys.size() == 0) {
            return Optional.of(ImmutableSet.of());
        }
        ImmutableSet.Builder uniqueKeysSetBuilder = ImmutableSet.builder();
        for (Set<String> set : uniqueKeys) {
            boolean allUniqueKeysExists = set.stream().allMatch(f -> this.rowType.getField((String)f, false, false) != null);
            if (!allUniqueKeysExists) continue;
            Set<Integer> keysPosition = set.stream().map(f -> this.rowType.getField((String)f, false, false).getIndex()).collect(Collectors.toSet());
            uniqueKeysSetBuilder.add((Object)ImmutableBitSet.of(keysPosition));
        }
        return Optional.of(uniqueKeysSetBuilder.build());
    }
}

