/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class StreamExecWindowTableFunction
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData> {
    private final WindowingStrategy windowingStrategy;

    public StreamExecWindowTableFunction(WindowingStrategy windowingStrategy, InputProperty inputEdge, RowType outputType, String description) {
        super(Collections.singletonList(inputEdge), (LogicalType)outputType, description);
        this.windowingStrategy = windowingStrategy;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        String[] inputFieldNames = inputRowType.getFieldNames().toArray(new String[0]);
        String windowSummary = this.windowingStrategy.toSummaryString(inputFieldNames);
        throw new UnsupportedOperationException(String.format("Currently Flink doesn't support individual window table-valued function %s.\n Please use window table-valued function with aggregate together using window_start and window_end as group keys.", windowSummary));
    }
}

