/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.common.CommonIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;

public class ExecNodeGraphGenerator {
    private final Map<FlinkPhysicalRel, ExecNode<?>> visitedRels = new IdentityHashMap();

    public ExecNodeGraph generate(List<FlinkPhysicalRel> relNodes) {
        ArrayList rootNodes = new ArrayList(relNodes.size());
        for (FlinkPhysicalRel relNode : relNodes) {
            rootNodes.add(this.generate(relNode));
        }
        return new ExecNodeGraph(rootNodes);
    }

    private ExecNode<?> generate(FlinkPhysicalRel rel) {
        ExecNode<?> execNode = this.visitedRels.get(rel);
        if (execNode != null) {
            return execNode;
        }
        if (rel instanceof CommonIntermediateTableScan) {
            throw new TableException("Intermediate RelNode can't be converted to ExecNode.");
        }
        ArrayList inputNodes = new ArrayList();
        for (RelNode input : rel.getInputs()) {
            inputNodes.add(this.generate((FlinkPhysicalRel)input));
        }
        execNode = rel.translateToExecNode();
        ArrayList<ExecEdge> inputEdges = new ArrayList<ExecEdge>(inputNodes.size());
        for (ExecNode execNode2 : inputNodes) {
            inputEdges.add(ExecEdge.builder().source(execNode2).target(execNode).build());
        }
        execNode.setInputEdges(inputEdges);
        this.visitedRels.put(rel, execNode);
        return execNode;
    }
}

