/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="TumblingWindow")
public class TumblingWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_SIZE = "size";
    @JsonProperty(value="size")
    private final Duration size;

    @JsonCreator
    public TumblingWindowSpec(@JsonProperty(value="size") Duration size) {
        this.size = (Duration)Preconditions.checkNotNull((Object)size);
    }

    @Override
    public String toSummaryString(String windowing) {
        return String.format("TUMBLE(%s, size=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.size));
    }

    public Duration getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TumblingWindowSpec that = (TumblingWindowSpec)o;
        return this.size.equals(that.size);
    }

    public int hashCode() {
        return Objects.hash(TumblingWindowSpec.class, this.size);
    }

    public String toString() {
        return String.format("TUMBLE(size=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.size));
    }
}

