/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.table.api.internal.CollectResultProvider;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

@Internal
final class CollectDynamicSink
implements DynamicTableSink {
    private final ObjectIdentifier tableIdentifier;
    private final DataType consumedDataType;
    private CollectResultIterator<RowData> iterator;

    CollectDynamicSink(ObjectIdentifier tableIdentifier, DataType consumedDataType) {
        this.tableIdentifier = tableIdentifier;
        this.consumedDataType = consumedDataType;
    }

    public CollectResultProvider getSelectResultProvider() {
        return new CollectResultProvider(){

            public void setJobClient(JobClient jobClient) {
                CollectDynamicSink.this.iterator.setJobClient(jobClient);
            }

            public CloseableIterator<Row> getResultIterator() {
                return CollectDynamicSink.this.iterator;
            }
        };
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return requestedMode;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return inputStream -> {
            CheckpointConfig checkpointConfig = inputStream.getExecutionEnvironment().getCheckpointConfig();
            ExecutionConfig config = inputStream.getExecutionConfig();
            TypeSerializer externalSerializer = ExternalTypeInfo.of((DataType)this.consumedDataType, (boolean)true).createSerializer(config);
            String accumulatorName = this.tableIdentifier.getObjectName();
            CollectSinkOperatorFactory factory = new CollectSinkOperatorFactory(externalSerializer, accumulatorName);
            CollectSinkOperator operator = (CollectSinkOperator)factory.getOperator();
            this.iterator = new CollectResultIterator(operator.getOperatorIdFuture(), externalSerializer, accumulatorName, checkpointConfig);
            CollectStreamSink sink = new CollectStreamSink(inputStream, factory);
            return sink.name("Collect table sink");
        };
    }

    public DynamicTableSink copy() {
        CollectDynamicSink copy = new CollectDynamicSink(this.tableIdentifier, this.consumedDataType);
        copy.iterator = this.iterator;
        return copy;
    }

    public String asSummaryString() {
        return String.format("TableToCollect(type=%s)", this.consumedDataType);
    }
}

