/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.jayway.jsonpath.internal.filter;

import org.apache.flink.calcite.shaded.com.jayway.jsonpath.InvalidPathException;

public enum RelationalOperator {
    GTE(">="),
    LTE("<="),
    EQ("=="),
    TSEQ("==="),
    NE("!="),
    TSNE("!=="),
    LT("<"),
    GT(">"),
    REGEX("=~"),
    NIN("NIN"),
    IN("IN"),
    CONTAINS("CONTAINS"),
    ALL("ALL"),
    SIZE("SIZE"),
    EXISTS("EXISTS"),
    TYPE("TYPE"),
    MATCHES("MATCHES"),
    EMPTY("EMPTY"),
    SUBSETOF("SUBSETOF");

    private final String operatorString;

    private RelationalOperator(String operatorString) {
        this.operatorString = operatorString;
    }

    public static RelationalOperator fromString(String operatorString) {
        for (RelationalOperator operator : RelationalOperator.values()) {
            if (!operator.operatorString.equals(operatorString.toUpperCase())) continue;
            return operator;
        }
        throw new InvalidPathException("Filter operator " + operatorString + " is not supported!");
    }

    public String toString() {
        return this.operatorString;
    }
}

