/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.WorkspaceConnectionInfoNative;
import com.supermap.data.WorkspaceType;
import com.supermap.data.WorkspaceVersion;
import java.util.Locale;

public class WorkspaceConnectionInfo
extends InternalHandleDisposable {
    private boolean m_readOnly;

    WorkspaceConnectionInfo(long handle, boolean disposable, boolean readOnly) {
        this.initialize(handle, disposable, readOnly);
    }

    public WorkspaceConnectionInfo(String tns, String database, String name, String user, String password) {
        long l = WorkspaceConnectionInfoNative.jni_New();
        this.initialize(l, true, false);
        this.reset(name, WorkspaceType.ORACLE, tns, database, user, password, "", WorkspaceVersion.UGC70);
    }

    public WorkspaceConnectionInfo(String server, String driver, String database, String name, String user, String password) {
        long l = WorkspaceConnectionInfoNative.jni_New();
        this.initialize(l, true, false);
        this.reset(name, WorkspaceType.SQL, server, database, user, password, driver, WorkspaceVersion.UGC70);
    }

    public WorkspaceConnectionInfo(String file) {
        long l = WorkspaceConnectionInfoNative.jni_New();
        this.initialize(l, true, false);
        if (file == null) {
            file = "";
        }
        WorkspaceType workspaceType = WorkspaceType.SXWU;
        WorkspaceVersion workspaceVersion = WorkspaceVersion.UGC70;
        if (file.endsWith(".sxw")) {
            workspaceType = WorkspaceType.SXW;
            workspaceVersion = WorkspaceVersion.UGC20;
        } else if (file.endsWith(".smw")) {
            workspaceType = WorkspaceType.SMW;
            workspaceVersion = WorkspaceVersion.UGC20;
        } else if (file.endsWith(".sxwu")) {
            workspaceType = WorkspaceType.SXWU;
        } else if (file.endsWith(".smwu")) {
            workspaceType = WorkspaceType.SMWU;
        }
        this.reset("", workspaceType, file, "", "", "", "", workspaceVersion);
    }

    public WorkspaceConnectionInfo() {
        long l = WorkspaceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setName(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        WorkspaceConnectionInfoNative.jni_SetName(this.getHandle(), value);
    }

    public WorkspaceType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceConnectionInfoNative.jni_GetType(this.getHandle());
        return (WorkspaceType)Enum.parseUGCValue(WorkspaceType.class, n);
    }

    public void setType(WorkspaceType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setType(WorkspaceType value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        WorkspaceConnectionInfoNative.jni_SetType(this.getHandle(), value.getUGCValue());
    }

    public String getServer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetServer(this.getHandle());
    }

    public void setServer(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setServer(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
            value = value.replaceAll("\\\\", "/");
        }
        WorkspaceConnectionInfoNative.jni_SetServer(this.getHandle(), value);
    }

    public String getDatabase() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetDataBase(this.getHandle());
    }

    public void setDatabase(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setDatabase(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        WorkspaceConnectionInfoNative.jni_SetDataBase(this.getHandle(), value);
    }

    public String getUser() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetUser(this.getHandle());
    }

    public void setUser(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setUser(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        WorkspaceConnectionInfoNative.jni_SetUser(this.getHandle(), value);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setPassword(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        WorkspaceConnectionInfoNative.jni_SetPassword(this.getHandle(), value);
    }

    public String getDriver() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceConnectionInfoNative.jni_GetDriver(this.getHandle());
    }

    public void setDriver(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setDriver(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        WorkspaceConnectionInfoNative.jni_SetDriver(this.getHandle(), value);
    }

    public WorkspaceVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceConnectionInfoNative.jni_GetVersion(this.getHandle());
        return (WorkspaceVersion)Enum.parseUGCValue(WorkspaceVersion.class, n);
    }

    public void setVersion(WorkspaceVersion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setDriver(String value)", "WorkspaceConnectionInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        WorkspaceConnectionInfoNative.jni_SetVersion(this.getHandle(), value.getUGCValue());
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "{Name=\"" + this.getName() + "\",Type=\"" + this.getType() + "\",Server=\"" + this.getServer() + "\",Database=\"" + this.getDatabase() + "\",Driver=\"" + this.getDriver() + "\",User=\"" + this.getUser() + "\",Password=\"" + this.getPassword() + "\" }";
        return string;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            WorkspaceConnectionInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    void reset() {
        this.reset("", WorkspaceType.DEFAULT, "", "", "", "", "", WorkspaceVersion.UGC70);
    }

    void reset(String name, WorkspaceType type, String server, String database, String user, String password, String driver, WorkspaceVersion version) {
        if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
            server = server.replaceAll("\\\\", "/");
        }
        WorkspaceConnectionInfoNative.jni_Reset(this.getHandle(), name, type.value(), server, database, user, password, driver, version.value());
    }

    void initialize(long handle, boolean disposable, boolean readOnly) {
        this.setHandle(handle, disposable);
        this.m_readOnly = readOnly;
    }

    protected void setReadOnly(boolean value) {
        this.m_readOnly = value;
    }

    protected static WorkspaceConnectionInfo createInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new WorkspaceConnectionInfo(handle, true, false);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(WorkspaceConnectionInfo connectionInfo) {
        connectionInfo.clearHandle();
    }

    protected static WorkspaceConnectionInfo internalCreateInstance(long handle) {
        return WorkspaceConnectionInfo.createInstance(handle);
    }

    protected static void internalClearHandle(WorkspaceConnectionInfo workInfo) {
        WorkspaceConnectionInfo.clearHandle(workInfo);
    }
}

