/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import java.io.Serializable;
import java.util.Date;

public class TimeSpan
implements Serializable,
Cloneable,
Comparable<TimeSpan> {
    private transient long m_timeSpan;
    private static final long millisecondsEachDay = 86400000L;
    private static final long millisecondsEachHour = 3600000L;
    private static final long millisecondsEachMinute = 60000L;

    public TimeSpan() {
        this.m_timeSpan = 0L;
    }

    public TimeSpan(long milliseconds) {
        this.m_timeSpan = milliseconds;
    }

    public TimeSpan(int hours, int minutes, int seconds) {
        this.m_timeSpan = (long)hours * 3600000L + (long)minutes * 60000L + (long)(seconds * 1000);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) {
        this.m_timeSpan = (long)days * 86400000L + (long)hours * 3600000L + (long)minutes * 60000L + (long)(seconds * 1000);
    }

    public long getTimeSpan() {
        return this.m_timeSpan;
    }

    public void setTimeSpan(long timeSpan) {
        this.m_timeSpan = timeSpan;
    }

    public int getDays() {
        return (int)(this.m_timeSpan / 86400000L);
    }

    public int getHours() {
        return (int)(this.m_timeSpan % 86400000L / 3600000L);
    }

    public int getTotalHours() {
        return (int)(this.m_timeSpan / 3600000L);
    }

    public int getMinutes() {
        return (int)(this.m_timeSpan % 3600000L / 60000L);
    }

    public int getTotalMinutes() {
        return (int)(this.m_timeSpan / 60000L);
    }

    public int getSeconds() {
        return (int)(this.m_timeSpan % 60000L / 1000L);
    }

    public int getTotalSeconds() {
        return (int)(this.m_timeSpan / 1000L);
    }

    @Override
    public int compareTo(TimeSpan anotherTimeSpan) {
        long l = anotherTimeSpan.getTimeSpan();
        return this.m_timeSpan < l ? -1 : (this.m_timeSpan == l ? 0 : 1);
    }

    public Date addToDate(Date date) {
        if (date != null) {
            date.setTime(date.getTime() + this.m_timeSpan);
        }
        return date;
    }

    public void add(TimeSpan anotherTimeSpan) {
        if (anotherTimeSpan != null) {
            this.m_timeSpan += anotherTimeSpan.getTimeSpan();
        }
    }

    public boolean equals(TimeSpan anotherTimeSpan) {
        long l = anotherTimeSpan.getTimeSpan();
        return this.m_timeSpan == l;
    }
}

