/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextureDataNative;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class TextureData
extends InternalHandleDisposable {
    protected TextureData(long srchandle) {
        if (srchandle == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = TextureDataNative.jni_New2(srchandle);
        this.setHandle(l, true);
    }

    public TextureData() {
        long l = TextureDataNative.jni_New();
        this.setHandle(l, true);
    }

    public TextureData(String name) {
        long l = TextureDataNative.jni_New();
        TextureDataNative.jni_setName(l, name);
        this.setHandle(l, true);
    }

    @Override
    public void dispose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        TextureDataNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public boolean fromFile(String filepath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextureDataNative.jni_FromFile(this.getHandle(), filepath);
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextureDataNative.jni_setName(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextureDataNative.jni_getName(this.getHandle());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextureDataNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextureDataNative.jni_GetHeight(this.getHandle());
    }

    public void setData(BufferedImage value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = value.getWidth();
        int n2 = value.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = value.getRGB(j, i);
            }
        }
        TextureDataNative.jni_SetData(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("TextureData", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[3];
        byte[] byArray = TextureDataNative.jni_GetData(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (byArray != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = 0;
                int n5 = i * n * n3 + j * n3;
                if (n3 == 3) {
                    Color color = new Color(byArray[n5] & 0xFF, byArray[n5 + 1] & 0xFF, byArray[n5 + 2] & 0xFF, 255);
                    n4 = color.getRGB();
                } else {
                    int n6 = byArray[n5 + 3] & 0xFF;
                    int n7 = byArray[n5 + 2] & 0xFF;
                    int n8 = byArray[n5 + 1] & 0xFF;
                    int n9 = byArray[n5] & 0xFF;
                    Color color = new Color(n7, n8, n9, n6);
                    n4 = color.getRGB();
                }
                bufferedImage.setRGB(j, i, n4);
            }
        }
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, n, n2, 0, 0, n, 0, 0, n2, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    protected static TextureData internalCreateInstance(long handle) {
        return new TextureData(handle);
    }
}

