/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarkerNative;
import com.supermap.data.SymbolMarkerStroke;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SymbolMarker
extends Symbol {
    private ArrayList<SymbolMarkerStroke> m_arrayList;

    SymbolMarker(long handle) {
        this.setHandle(handle, false);
        this.refreshStrokeList(handle);
    }

    private void refreshStrokeList(long handle) {
        Object object;
        int n;
        if (this.m_arrayList != null) {
            for (n = 0; n < this.m_arrayList.size(); ++n) {
                object = this.m_arrayList.get(n);
                ((InternalHandle)object).clearHandle();
            }
            this.m_arrayList.clear();
        } else {
            this.m_arrayList = new ArrayList();
        }
        n = SymbolMarkerNative.jni_GetStrokesCount(handle);
        if (n > 0) {
            object = new long[n];
            SymbolMarkerNative.jni_GetStrokeHandle(handle, (long[])object);
            for (int i = 0; i < n; ++i) {
                if (object[i] == 0L) continue;
                SymbolMarkerStroke symbolMarkerStroke = new SymbolMarkerStroke((long)object[i]);
                this.m_arrayList.add(symbolMarkerStroke);
            }
        }
    }

    public SymbolMarker() {
        long l = SymbolMarkerNative.jni_New();
        this.setHandle(l, true);
        this.setLibrary(null);
        this.refreshStrokeList(l);
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        if (geometry.getStyle() != null) {
            geometry2.setStyle(geometry.getStyle());
        }
        Rectangle2D rectangle2D = geometry2.getBounds();
        InternalBufferImage internalBufferImage = null;
        boolean bl = false;
        try {
            if (geometry2.getType().equals(GeometryType.GEOPOINT) && geometry2.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)geometry2.getStyle().getMarkerSize().getWidth() + 10, (int)geometry2.getStyle().getMarkerSize().getHeight() + 10);
                geometry2.offset(-rectangle2D.getLeft() + geometry2.getStyle().getMarkerSize().getWidth() / 2.0 + 5.0, -rectangle2D.getBottom() + geometry2.getStyle().getMarkerSize().getHeight() / 2.0 + 5.0);
            } else {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 10, (int)rectangle2D.getHeight() + 10);
                geometry2.offset(-rectangle2D.getLeft() + 5.0, -rectangle2D.getBottom() + 5.0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = SymbolMarkerNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry2.getHandle());
        if (bl) {
            if (geometry2.getType().equals(GeometryType.GEOPOINT)) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - internalBufferImage.getWidth() / 2, (int)rectangle2D.getBottom() - internalBufferImage.getHeight() / 2, null);
            } else {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 5, (int)rectangle2D.getBottom() - 5, null);
            }
        }
        internalBufferImage.makeSureNativeObjectLive();
        geometry2.makeSureNativeObjectLive();
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        Object object;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        boolean bl = false;
        Point2Ds point2Ds = null;
        int n = points.getCount();
        try {
            if (n == 1) {
                object = points.getItem(0);
                rectangle2D = new Rectangle2D((Point2D)object, new Size2D(0.0, 0.0));
                internalBufferImage = new InternalBufferImage((int)style.getMarkerSize().getWidth() + 10, (int)style.getMarkerSize().getHeight() + 10);
                ((Point2D)object).offset(-rectangle2D.getLeft() + style.getMarkerSize().getWidth() / 2.0 + 5.0, -rectangle2D.getBottom() + style.getMarkerSize().getHeight() / 2.0 + 5.0);
                point2Ds = new Point2Ds();
                point2Ds.add((Point2D)object);
            } else {
                object = new GeoLine(points);
                rectangle2D = ((Geometry)object).getBounds();
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 10, (int)rectangle2D.getHeight() + 10);
                ((GeoLine)object).offset(-rectangle2D.getLeft() + 5.0, -rectangle2D.getBottom() + 5.0);
                point2Ds = ((GeoLine)object).getPart(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        object = new double[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            object[i] = point2Ds.getItem(i).getX();
            dArray[i] = point2Ds.getItem(i).getY();
        }
        bl = style == null ? SymbolMarkerNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), (double[])object, dArray, 0L) : SymbolMarkerNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), (double[])object, dArray, style.getHandle());
        if (bl) {
            if (n == 1) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - internalBufferImage.getWidth() / 2, (int)rectangle2D.getBottom() - internalBufferImage.getHeight() / 2, null);
            } else {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 5, (int)rectangle2D.getBottom() - 5, null);
            }
        }
        internalBufferImage.makeSureNativeObjectLive();
        style.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Point2Ds points, GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), points, style);
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        return bl;
    }

    public int computeDisplaySize(int symbolSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbolSize < 0) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeDisplaySize(this.getHandle(), symbolSize);
    }

    public int computeSymbolSize(int displaySize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (displaySize < 0) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeSymbolSize(this.getHandle(), displaySize);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public int fromGeometry(Geometry geometry, Rectangle2D bounds) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geometry);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_FromGeometry(l, l2, bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
        geometry.makeSureNativeObjectLive();
        this.refreshStrokeList(l);
        return this.getID();
    }

    @Override
    public SymbolType getType() {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SymbolMarkerNative.jni_IsPipeNode(l);
        if (bl) {
            return SymbolType.PIPENODE;
        }
        return SymbolType.MARKER;
    }

    public Point getOrigin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrigin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        SymbolMarkerNative.jni_GetOrigin(this.getHandle(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void setOrigin(Point value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrigin(Point value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_SetOrigin(this.getHandle(), value.x, value.y);
    }

    public SymbolMarkerStroke get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_arrayList.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.GetMatrialStream(index);
        return this.m_arrayList.get(index);
    }

    private void GetMatrialStream(int index) {
        SymbolMarkerNative.jni_GetMatrialStream(this.getHandle(), this.getLibrary().getLibPath(), index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_arrayList.size();
    }

    @Override
    protected void clearHandle() {
        if (this.m_arrayList != null) {
            for (int i = 0; i < this.m_arrayList.size(); ++i) {
                SymbolMarkerStroke symbolMarkerStroke = this.m_arrayList.get(i);
                symbolMarkerStroke.clearHandle();
            }
            this.m_arrayList.clear();
        }
        this.setHandle(0L);
    }

    public int fromSVG(String svgFile) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("fromSVG(String svgFile", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerNative.jni_FromSVG(l, svgFile);
        this.refreshStrokeList(l);
        return this.getID();
    }

    public boolean toSVG(String svgFile) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("toSVG(String svgFile)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolMarkerNative.jni_ToSVG(l, svgFile);
    }
}

