/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolGroupsNative;
import com.supermap.data.SymbolLibrary;
import java.util.ArrayList;

public class SymbolGroups {
    private SymbolGroup m_parentSymbolGroup;
    private ArrayList m_symbolGroups;
    private SymbolLibrary m_symbolLibrary;

    SymbolGroups(SymbolGroup symbolGroup) {
        this.m_parentSymbolGroup = symbolGroup;
        this.m_symbolGroups = new ArrayList();
        this.m_symbolLibrary = symbolGroup.getLib();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolGroup);
    }

    public SymbolGroup get(int index) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("index", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return (SymbolGroup)this.m_symbolGroups.get(index);
    }

    public SymbolGroup get(String name) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("get(String name)", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroup symbolGroup = null;
        int n = this.indexOf(name);
        if (n != -1) {
            symbolGroup = (SymbolGroup)this.m_symbolGroups.get(n);
        }
        return symbolGroup;
    }

    public int getCount() {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_symbolGroups.size();
    }

    public int indexOf(String name) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("indexOf(String name)", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = SymbolGroupsNative.jni_IndexOf(this.m_parentSymbolGroup.getHandle(), name);
        }
        return n;
    }

    public SymbolGroup create(String name) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("create(String name) ", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.contains(name)) {
            String string = InternalResource.loadString("value", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolGroupsNative.jni_Create(this.m_parentSymbolGroup.getHandle(), name);
        SymbolGroup symbolGroup = null;
        if (l != 0L) {
            symbolGroup = new SymbolGroup(l, this.m_parentSymbolGroup);
            this.m_symbolGroups.add(symbolGroup);
        }
        return symbolGroup;
    }

    public boolean contains(String name) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("contains(String name)", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.indexOf(name) != -1;
    }

    public boolean remove(String name) {
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("remove(String name)", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (name == null || name.trim().length() == 0) {
            bl = false;
        } else {
            int n = this.indexOf(name);
            if (n == -1) {
                bl = false;
            } else {
                bl = SymbolGroupsNative.jni_Remove(this.m_parentSymbolGroup.getHandle(), n);
                if (bl) {
                    int n2;
                    SymbolGroup symbolGroup = this.get(n);
                    int n3 = symbolGroup.getChildGroups().getCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.m_symbolGroups.add(symbolGroup.getChildGroups().get(n2));
                    }
                    n2 = symbolGroup.getCount();
                    for (int i = 0; i < n2; ++i) {
                        this.m_parentSymbolGroup.getSymbols().add(symbolGroup.get(i));
                        symbolGroup.get(i).setGroup(this.m_parentSymbolGroup);
                    }
                    this.m_symbolGroups.remove(symbolGroup);
                    symbolGroup.clearHandle();
                }
            }
        }
        return bl;
    }

    void reset() {
        int n;
        if (this.m_parentSymbolGroup == null || this.m_parentSymbolGroup.getHandle() == 0L || this.m_symbolGroups == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        for (n = 0; n < this.m_symbolGroups.size(); ++n) {
            ((SymbolGroup)this.m_symbolGroups.get(n)).clearHandle();
        }
        this.m_symbolGroups.clear();
        n = SymbolGroupsNative.jni_GetCount(this.m_parentSymbolGroup.getHandle());
        if (n > 0) {
            long[] lArray = new long[n];
            SymbolGroupsNative.jni_GetSymbolGroups(this.m_parentSymbolGroup.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                SymbolGroup symbolGroup = new SymbolGroup(lArray[i], this.m_parentSymbolGroup);
                this.m_symbolGroups.add(symbolGroup);
            }
        }
    }

    protected void clearHandle() {
        this.m_parentSymbolGroup = null;
        if (this.m_symbolGroups != null) {
            for (int i = 0; i < this.m_symbolGroups.size(); ++i) {
                ((SymbolGroup)this.m_symbolGroups.get(i)).clearHandle();
            }
            this.m_symbolGroups.clear();
            this.m_symbolGroups = null;
        }
        this.m_symbolLibrary = null;
    }
}

