/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFillLibraryNative;
import com.supermap.data.SymbolLibrary;

public class SymbolFillLibrary
extends SymbolLibrary {
    SymbolFillLibrary(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillLibraryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean toFile(String filePath, int[] extractedIDs) {
        long l = SymbolFillLibraryNative.jni_New();
        SymbolFillLibrary symbolFillLibrary = new SymbolFillLibrary(l);
        symbolFillLibrary.clear();
        symbolFillLibrary.setHandle(l, true);
        for (int i = 0; i < extractedIDs.length; ++i) {
            SymbolFill symbolFill = (SymbolFill)this.findSymbol(extractedIDs[i]);
            if (symbolFill == null) continue;
            SymbolFill symbolFill2 = (SymbolFill)Symbol.createInstance(symbolFill);
            symbolFillLibrary.add(symbolFill2);
        }
        return symbolFillLibrary.toFile(filePath);
    }
}

