/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariant;
import com.supermap.data.RepresentationType;

public class RepresentationElement {
    private Geometry m_geometry = null;
    private RepresentationType m_type = RepresentationType.ORIGINAL;
    private Object m_CustomValue = null;

    public RepresentationElement() {
        this.setType(RepresentationType.GEOMETRYANDSTYLE);
    }

    public RepresentationElement(Geometry geometry, RepresentationType type) {
        this.m_geometry = geometry;
        this.m_type = type;
    }

    public void setGeometry(Geometry geometry) {
        if (geometry != null && geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_geometry = geometry.clone();
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    public Geometry getGeometry() {
        return this.m_geometry;
    }

    public RepresentationType getType() {
        return this.m_type;
    }

    public void setType(RepresentationType type) {
        this.m_type = type;
    }

    public Object getCustomValue() {
        return this.m_CustomValue;
    }

    public void setCustomValue(Object value) {
        if (!InternalVariant.isSupportedInstance(value)) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_CustomValue = value;
    }
}

