/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoCoordSys;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PrjCoordSysNative;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.PrjFileType;
import com.supermap.data.PrjFileVersion;
import com.supermap.data.PrjParameter;
import com.supermap.data.Projection;
import com.supermap.data.Unit;

public class PrjCoordSys
extends InternalHandleDisposable {
    private GeoCoordSys m_geoCoordSys = null;
    private Projection m_projection = null;
    private PrjParameter m_prjParameter = null;

    public PrjCoordSys() {
        long l = PrjCoordSysNative.jni_New();
        this.setHandle(l, true);
        PrjCoordSysNative.jni_Reset(this.getHandle());
    }

    public PrjCoordSys(PrjCoordSysType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = PrjCoordSysNative.jni_New2(type.getUGCValue());
        this.setHandle(l, true);
    }

    public PrjCoordSys(GeoCoordSys geoCoordSys, Projection projection, PrjParameter prjParameter, String name) {
        if (geoCoordSys == null || geoCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("geoCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (projection == null || projection.getHandle() == 0L) {
            String string = InternalResource.loadString("projection", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjParameter == null || prjParameter.getHandle() == 0L) {
            String string = InternalResource.loadString("prjParameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = PrjCoordSysNative.jni_New3(geoCoordSys.getHandle(), projection.getHandle(), prjParameter.getHandle(), name);
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(projection);
        InternalHandleDisposable.makeSureNativeObjectLive(prjParameter);
    }

    public PrjCoordSys(PrjCoordSys prjCoordSys) {
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = PrjCoordSysNative.jni_Clone(prjCoordSys.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
    }

    public PrjCoordSys(int epsgCode) {
        if (epsgCode <= 0) {
            String string = InternalResource.loadString("prjCoordSys", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = PrjCoordSysNative.jni_NewEPSG(epsgCode);
        this.setHandle(l, true);
    }

    PrjCoordSys(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public static PrjCoordSys fromEPSG(int epsgCode) {
        return new PrjCoordSys(epsgCode);
    }

    protected static PrjCoordSys createInstance(long handle, boolean disposable) {
        return new PrjCoordSys(handle, disposable);
    }

    public PrjCoordSys clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new PrjCoordSys(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            PrjCoordSysNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_geoCoordSys != null) {
            this.m_geoCoordSys.clearHandle();
            this.m_geoCoordSys = null;
        }
        if (this.m_projection != null) {
            this.m_projection.clearHandle();
            this.m_projection = null;
        }
        if (this.m_prjParameter != null) {
            this.m_prjParameter.clearHandle();
            this.m_prjParameter = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(PrjCoordSys prjCoordSys) {
        prjCoordSys.clearHandle();
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return PrjCoordSysNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSysNative.jni_SetName(this.getHandle(), value);
    }

    public PrjCoordSysType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = PrjCoordSysNative.jni_GetType(this.getHandle());
        return (PrjCoordSysType)Enum.parseUGCValue(PrjCoordSysType.class, n);
    }

    public void setType(PrjCoordSysType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(GeoCoordSysType value) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSysNative.jni_SetType(this.getHandle(), value.getUGCValue());
    }

    public GeoCoordSys getGeoCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if ((this.m_geoCoordSys == null || this.m_geoCoordSys.getHandle() == 0L) && (l = PrjCoordSysNative.jni_GetGeoCoordSys(this.getHandle())) != 0L) {
            this.m_geoCoordSys = new GeoCoordSys(l, false);
        }
        GeoCoordSys geoCoordSys = null;
        if (this.getType() != PrjCoordSysType.PCS_NON_EARTH) {
            geoCoordSys = this.m_geoCoordSys;
        }
        return geoCoordSys;
    }

    public void setGeoCoordSys(GeoCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeoCoordSys(GeoCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != PrjCoordSysType.PCS_USER_DEFINED && this.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            String string = InternalResource.loadString("setGeoCoordSys(GeoCoordSys value)", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        value.getName();
        PrjCoordSysNative.jni_SetGeoCoordSys(this.getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public Projection getProjection() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProjection()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if ((this.m_projection == null || this.m_projection.getHandle() == 0L) && (l = PrjCoordSysNative.jni_GetProjection(this.getHandle())) != 0L) {
            this.m_projection = new Projection(l, false);
        }
        Projection projection = null;
        if (this.getType() != PrjCoordSysType.PCS_NON_EARTH && this.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            projection = this.m_projection;
        }
        return projection;
    }

    public void setProjection(Projection value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProjection(Projection value) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != PrjCoordSysType.PCS_USER_DEFINED) {
            String string = InternalResource.loadString("setProjection(Projection value) ", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        value.getType();
        PrjCoordSysNative.jni_SetProjection(this.getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public PrjParameter getPrjParameter() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjParameter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if ((this.m_prjParameter == null || this.m_prjParameter.getHandle() == 0L) && (l = PrjCoordSysNative.jni_GetPrjParameter(this.getHandle())) != 0L) {
            this.m_prjParameter = new PrjParameter(l, false);
        }
        PrjParameter prjParameter = null;
        if (this.getType() != PrjCoordSysType.PCS_NON_EARTH && this.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            prjParameter = this.m_prjParameter;
        }
        return prjParameter;
    }

    public void setPrjParameter(PrjParameter value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjParameter(PrjParameter value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != PrjCoordSysType.PCS_USER_DEFINED) {
            String string = InternalResource.loadString("setPrjParameter(PrjParameter value)", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSysNative.jni_SetPrjParameter(this.getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public Unit getCoordUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = PrjCoordSysNative.jni_GetCoordUnit(this.getHandle());
        if (n == 0) {
            n = 1001745329;
        }
        if (n == 1) {
            n = 10000;
        }
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setCoordUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(value);
        PrjCoordSysNative.jni_SetCoordUnit(this.getHandle(), n);
    }

    public Unit getDistanceUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = PrjCoordSysNative.jni_GetDistUnit(this.getHandle());
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setDistanceUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSysNative.jni_SetDistUnit(this.getHandle(), value.getUGCValue());
    }

    public boolean fromXML(String xml) {
        return this.fromXML(xml, 0);
    }

    public boolean fromXML(String xml, int version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = PrjCoordSysNative.jni_FromXML(this.getHandle(), xml, version);
        }
        return bl;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return PrjCoordSysNative.jni_ToXML(this.getHandle(), version);
    }

    @Deprecated
    public int toEPSGCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toEPSGCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return PrjCoordSysNative.jni_ToEPSGCode(this.getHandle());
    }

    public boolean fromEPSGCode(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromEPSGCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return PrjCoordSysNative.jni_FromEPSGCode(this.getHandle(), value);
    }

    public boolean toFile(String path, PrjFileVersion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile(String path, PrjFileVersion value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.getUGCValue();
        return PrjCoordSysNative.jni_ToFile(this.getHandle(), path, n);
    }

    public boolean fromFile(String path, PrjFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String path, PrjFileVersion value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.getUGCValue();
        return PrjCoordSysNative.jni_FromFile(this.getHandle(), path, n);
    }

    public int getEPSGCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return PrjCoordSysNative.jni_GetEPSGCode(this.getHandle());
    }

    public void setEPSGCode(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        PrjCoordSysNative.jni_SetEPSGCode(this.getHandle(), value);
    }
}

