/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetMosaic;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalResource;
import com.supermap.data.MosaicPixelValues;
import com.supermap.data.MosaicToolkitNative;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.Rectangle2D;
import java.awt.Point;
import java.io.File;
import java.util.HashMap;

public class MosaicToolkit {
    public static HashMap<Integer, String> getAllFiles(DatasetMosaic datasetMosaic, Boolean containsOverviews) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, 0L);
    }

    public static HashMap<Integer, String> getFilesByBounds(DatasetMosaic datasetMosaic, Rectangle2D extractBounds, Boolean containsOverviews) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (extractBounds.isEmpty()) {
            String string = InternalResource.loadString("extractBounds", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{extractBounds.getLeft(), extractBounds.getBottom(), extractBounds.getRight(), extractBounds.getTop()};
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, dArray, 0L);
    }

    public static HashMap<Integer, String> getFilesByGeoRegion(DatasetMosaic datasetMosaic, GeoRegion extractRegion, Boolean containsOverviews) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (extractRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, extractRegion.getHandle());
    }

    public static boolean hasPyramid(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            String string = InternalResource.loadString("String", "Global_StringIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(filePath);
        if (file.isDirectory()) {
            String string = InternalResource.loadString("String", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            return false;
        }
        return MosaicToolkitNative.jni_HasPyramid(filePath);
    }

    public static boolean buildPyramid(String filePath, PyramidResampleType type) {
        if (filePath == null || filePath.isEmpty()) {
            String string = InternalResource.loadString("String", "Global_StringIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(filePath);
        if (file.isDirectory()) {
            String string = InternalResource.loadString("String", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = type.getUGCValue();
        return MosaicToolkitNative.jni_BuildPyramid(filePath, n);
    }

    public static MosaicPixelValues getValue(DatasetMosaic datasetMosaic, Point2D point2D) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D == null || point2D.isEmpty()) {
            String string = InternalResource.loadString("point2D", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{point2D.x, point2D.y};
        double[] dArray2 = new double[15];
        MosaicPixelValues mosaicPixelValues = new MosaicPixelValues();
        mosaicPixelValues.m_filePath = MosaicToolkitNative.jni_GetValue(datasetMosaic.getHandle(), dArray, dArray2);
        if (mosaicPixelValues.m_filePath != null && mosaicPixelValues.m_filePath.length() > 1) {
            mosaicPixelValues.m_footPrintID = (int)dArray2[0];
            int n = (int)dArray2[1];
            mosaicPixelValues.m_pixelFormat = (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
            mosaicPixelValues.m_location = new Point((int)dArray2[2], (int)dArray2[3]);
            mosaicPixelValues.m_bandCount = (int)dArray2[4];
            mosaicPixelValues.m_dBandValues = new double[mosaicPixelValues.m_bandCount];
            for (int i = 0; i < mosaicPixelValues.m_bandCount; ++i) {
                mosaicPixelValues.m_dBandValues[i] = dArray2[i + 5];
            }
            return mosaicPixelValues;
        }
        return null;
    }

    public static String getFileInfo(String filePath) {
        if (filePath == null || filePath.length() < 1) {
            return null;
        }
        return MosaicToolkitNative.jni_GetFileInfo(filePath);
    }
}

